/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch.scanners;

import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.AudioDevice;
import com.twilio.audioswitch.scanners.Scanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00182\u0010\u0010\u001d\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0012\u0010 \u001a\u00020\u0016*\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u0004\u0018\u00010\t8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/twilio/audioswitch/scanners/AudioDeviceScanner;", "Landroid/media/AudioDeviceCallback;", "Lcom/twilio/audioswitch/scanners/Scanner;", "audioManager", "Landroid/media/AudioManager;", "handler", "Landroid/os/Handler;", "(Landroid/media/AudioManager;Landroid/os/Handler;)V", "listener", "Lcom/twilio/audioswitch/scanners/Scanner$Listener;", "getListener$audioswitch_release$annotations", "()V", "getListener$audioswitch_release", "()Lcom/twilio/audioswitch/scanners/Scanner$Listener;", "setListener$audioswitch_release", "(Lcom/twilio/audioswitch/scanners/Scanner$Listener;)V", "audioDevice", "Lcom/twilio/audioswitch/AudioDevice;", "Landroid/media/AudioDeviceInfo;", "getAudioDevice", "(Landroid/media/AudioDeviceInfo;)Lcom/twilio/audioswitch/AudioDevice;", "isDeviceActive", "", "onAudioDevicesAdded", "", "addedDevices", "", "([Landroid/media/AudioDeviceInfo;)V", "onAudioDevicesRemoved", "removedDevices", "start", "stop", "isAudioDevice", "audioswitch_release"})
@RequiresApi(value=23)
public final class AudioDeviceScanner
extends AudioDeviceCallback
implements Scanner {
    @Nullable
    private Scanner.Listener listener;
    private final AudioManager audioManager;
    private final Handler handler;

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getListener$audioswitch_release$annotations() {
    }

    @Nullable
    public final Scanner.Listener getListener$audioswitch_release() {
        return this.listener;
    }

    public final void setListener$audioswitch_release(@Nullable Scanner.Listener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isDeviceActive(@NotNull AudioDevice audioDevice) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
            AudioDeviceInfo[] audioDeviceInfoArray = this.audioManager.getDevices(2);
            Intrinsics.checkNotNullExpressionValue((Object)audioDeviceInfoArray, (String)"this.audioManager\n      \u2026ager.GET_DEVICES_OUTPUTS)");
            AudioDeviceInfo[] $this$any$iv = audioDeviceInfoArray;
            boolean $i$f$any = false;
            AudioDeviceInfo[] audioDeviceInfoArray2 = $this$any$iv;
            int n = audioDeviceInfoArray2.length;
            for (int i = 0; i < n; ++i) {
                AudioDeviceInfo element$iv;
                AudioDeviceInfo it = element$iv = audioDeviceInfoArray2[i];
                boolean bl2 = false;
                AudioDeviceInfo audioDeviceInfo = it;
                Intrinsics.checkNotNullExpressionValue((Object)audioDeviceInfo, (String)"it");
                boolean audioDevice1 = this.isAudioDevice(audioDeviceInfo, audioDevice);
                if (!audioDevice1) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean start(@NotNull Scanner.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        this.audioManager.registerAudioDeviceCallback((AudioDeviceCallback)this, this.handler);
        return true;
    }

    @Override
    public boolean stop() {
        this.audioManager.unregisterAudioDeviceCallback((AudioDeviceCallback)this);
        this.listener = null;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void onAudioDevicesAdded(@Nullable AudioDeviceInfo[] addedDevices) {
        super.onAudioDevicesAdded(addedDevices);
        Object object = addedDevices;
        if (addedDevices != null) {
            void $this$mapNotNullTo$iv$iv;
            AudioDeviceInfo[] $this$mapNotNull$iv = object;
            boolean $i$f$mapNotNull = false;
            AudioDeviceInfo[] audioDeviceInfoArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var9_11 = $this$forEach$iv$iv$iv;
            int n = ((void)var9_11).length;
            for (int i = 0; i < n; ++i) {
                AudioDevice audioDevice;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var9_11[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (this.getAudioDevice((AudioDeviceInfo)it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                AudioDevice it$iv$iv = audioDevice;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (object != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    AudioDevice it = (AudioDevice)element$iv;
                    boolean bl = false;
                    Scanner.Listener listener = this.listener;
                    if (listener != null) {
                        listener.onDeviceConnected(it);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onAudioDevicesRemoved(@Nullable AudioDeviceInfo[] removedDevices) {
        super.onAudioDevicesRemoved(removedDevices);
        Object object = removedDevices;
        if (removedDevices != null) {
            void $this$mapNotNullTo$iv$iv;
            AudioDeviceInfo[] $this$mapNotNull$iv = object;
            boolean $i$f$mapNotNull = false;
            AudioDeviceInfo[] audioDeviceInfoArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            void var9_11 = $this$forEach$iv$iv$iv;
            int n = ((void)var9_11).length;
            for (int i = 0; i < n; ++i) {
                AudioDevice audioDevice;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var9_11[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (this.getAudioDevice((AudioDeviceInfo)it) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                AudioDevice it$iv$iv = audioDevice;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (object != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    AudioDevice it = (AudioDevice)element$iv;
                    boolean bl = false;
                    Scanner.Listener listener = this.listener;
                    if (listener != null) {
                        listener.onDeviceDisconnected(it);
                    }
                }
            }
        }
    }

    @Nullable
    public final AudioDevice getAudioDevice(@NotNull AudioDeviceInfo $this$audioDevice) {
        Intrinsics.checkNotNullParameter((Object)$this$audioDevice, (String)"$this$audioDevice");
        return $this$audioDevice.getType() == 7 || $this$audioDevice.getType() == 8 ? (AudioDevice)new AudioDevice.BluetoothHeadset(((Object)$this$audioDevice.getProductName()).toString()) : (Build.VERSION.SDK_INT >= 31 && ($this$audioDevice.getType() == 26 || $this$audioDevice.getType() == 27) ? (AudioDevice)new AudioDevice.BluetoothHeadset(((Object)$this$audioDevice.getProductName()).toString()) : ($this$audioDevice.getType() == 3 || $this$audioDevice.getType() == 4 || $this$audioDevice.getType() == 22 ? (AudioDevice)new AudioDevice.WiredHeadset(null, 1, null) : ($this$audioDevice.getType() == 1 ? (AudioDevice)new AudioDevice.Earpiece(null, 1, null) : (AudioDevice)($this$audioDevice.getType() == 2 ? new AudioDevice.Speakerphone(null, 1, null) : null))));
    }

    public final boolean isAudioDevice(@NotNull AudioDeviceInfo $this$isAudioDevice, @NotNull AudioDevice audioDevice) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isAudioDevice, (String)"$this$isAudioDevice");
        Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
        AudioDevice audioDevice2 = audioDevice;
        if (audioDevice2 instanceof AudioDevice.BluetoothHeadset) {
            bl = $this$isAudioDevice.getType() == 7 || $this$isAudioDevice.getType() == 8 ? true : Build.VERSION.SDK_INT >= 31 && ($this$isAudioDevice.getType() == 26 || $this$isAudioDevice.getType() == 27);
        } else if (audioDevice2 instanceof AudioDevice.Earpiece) {
            bl = $this$isAudioDevice.getType() == 1;
        } else if (audioDevice2 instanceof AudioDevice.Speakerphone) {
            bl = $this$isAudioDevice.getType() == 2;
        } else if (audioDevice2 instanceof AudioDevice.WiredHeadset) {
            bl = $this$isAudioDevice.getType() == 3 || $this$isAudioDevice.getType() == 4 ? true : Build.VERSION.SDK_INT >= 26 && $this$isAudioDevice.getType() == 22;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public AudioDeviceScanner(@NotNull AudioManager audioManager, @NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.audioManager = audioManager;
        this.handler = handler;
    }

    @Override
    public boolean start(@NotNull Function1<? super AudioDevice, Unit> onDeviceConnected2, @NotNull Function1<? super AudioDevice, Unit> onDeviceDisconnected2) {
        Intrinsics.checkNotNullParameter(onDeviceConnected2, (String)"onDeviceConnected");
        Intrinsics.checkNotNullParameter(onDeviceDisconnected2, (String)"onDeviceDisconnected");
        return Scanner.DefaultImpls.start(this, onDeviceConnected2, onDeviceDisconnected2);
    }

    @Override
    public boolean isDeviceInactive(@NotNull AudioDevice audioDevice) {
        Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
        return Scanner.DefaultImpls.isDeviceInactive(this, audioDevice);
    }
}

