/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.media.AudioManager;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.AbstractAudioSwitch;
import com.twilio.audioswitch.AudioDevice;
import com.twilio.audioswitch.AudioDeviceManager;
import com.twilio.audioswitch.LegacyAudioSwitch;
import com.twilio.audioswitch.android.Logger;
import com.twilio.audioswitch.android.ProductionLogger;
import com.twilio.audioswitch.bluetooth.BluetoothHeadsetManager;
import com.twilio.audioswitch.scanners.LegacyAudioDeviceScanner;
import com.twilio.audioswitch.scanners.Scanner;
import com.twilio.audioswitch.wired.WiredHeadsetReceiver;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B;\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\u0010\fBi\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0014J\b\u0010!\u001a\u00020\u001fH\u0014J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0016R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/twilio/audioswitch/LegacyAudioSwitch;", "Lcom/twilio/audioswitch/AbstractAudioSwitch;", "context", "Landroid/content/Context;", "loggingEnabled", "", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "preferredDeviceList", "", "Ljava/lang/Class;", "Lcom/twilio/audioswitch/AudioDevice;", "(Landroid/content/Context;ZLandroid/media/AudioManager$OnAudioFocusChangeListener;Ljava/util/List;)V", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioManager", "Landroid/media/AudioManager;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "wiredHeadsetReceiver", "Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;", "headsetManager", "Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "scanner", "Lcom/twilio/audioswitch/scanners/Scanner;", "(Landroid/content/Context;Landroid/media/AudioManager$OnAudioFocusChangeListener;Lcom/twilio/audioswitch/android/Logger;Ljava/util/List;Landroid/media/AudioManager;Lcom/twilio/audioswitch/AudioDeviceManager;Lcom/twilio/audioswitch/wired/WiredHeadsetReceiver;Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;Lcom/twilio/audioswitch/scanners/Scanner;)V", "getHeadsetManager$audioswitch_release$annotations", "()V", "getHeadsetManager$audioswitch_release", "()Lcom/twilio/audioswitch/bluetooth/BluetoothHeadsetManager;", "onActivate", "", "audioDevice", "onDeactivate", "onDeviceConnected", "onDeviceDisconnected", "audioswitch_release"})
public final class LegacyAudioSwitch
extends AbstractAudioSwitch {
    @Nullable
    private final BluetoothHeadsetManager headsetManager;

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getHeadsetManager$audioswitch_release$annotations() {
    }

    @Nullable
    public final BluetoothHeadsetManager getHeadsetManager$audioswitch_release() {
        return this.headsetManager;
    }

    @Override
    public void onDeviceConnected(@NotNull AudioDevice audioDevice) {
        Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
        if (audioDevice instanceof AudioDevice.BluetoothHeadset) {
            CollectionsKt.removeAll((Iterable)this.getAvailableUniqueAudioDevices(), (Function1)onDeviceConnected.1.INSTANCE);
        }
        super.onDeviceConnected(audioDevice);
    }

    @Override
    public void onDeviceDisconnected(@NotNull AudioDevice audioDevice) {
        boolean wasRemoved2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
        if (audioDevice instanceof AudioDevice.BluetoothHeadset) {
            if (this.getUserSelectedAudioDevice() instanceof AudioDevice.BluetoothHeadset) {
                this.setUserSelectedAudioDevice(null);
            }
            bl = CollectionsKt.removeAll((Iterable)this.getAvailableUniqueAudioDevices(), (Function1)onDeviceDisconnected.wasRemoved.1.INSTANCE);
        } else {
            if (Intrinsics.areEqual((Object)this.getUserSelectedAudioDevice(), (Object)audioDevice)) {
                this.setUserSelectedAudioDevice(null);
            }
            bl = wasRemoved2 = this.getAvailableUniqueAudioDevices().remove(audioDevice);
        }
        if (audioDevice instanceof AudioDevice.WiredHeadset && this.getAudioDeviceManager$audioswitch_release().hasEarpiece()) {
            wasRemoved2 = this.getAvailableUniqueAudioDevices().add(new AudioDevice.Earpiece(null, 1, null)) || wasRemoved2;
        }
        AbstractAudioSwitch.selectAudioDevice$default(this, wasRemoved2, null, 2, null);
    }

    @Override
    protected void onActivate(@NotNull AudioDevice audioDevice) {
        block2: {
            AudioDevice audioDevice2;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
                    audioDevice2 = audioDevice;
                    if (!(audioDevice2 instanceof AudioDevice.BluetoothHeadset)) break block1;
                    this.getAudioDeviceManager$audioswitch_release().enableSpeakerphone(false);
                    BluetoothHeadsetManager bluetoothHeadsetManager = this.headsetManager;
                    if (bluetoothHeadsetManager == null) break block2;
                    bluetoothHeadsetManager.activate();
                    break block2;
                }
                if (!(audioDevice2 instanceof AudioDevice.Earpiece) && !(audioDevice2 instanceof AudioDevice.WiredHeadset)) break block3;
                this.getAudioDeviceManager$audioswitch_release().enableSpeakerphone(false);
                BluetoothHeadsetManager bluetoothHeadsetManager = this.headsetManager;
                if (bluetoothHeadsetManager == null) break block2;
                bluetoothHeadsetManager.deactivate();
                break block2;
            }
            if (!(audioDevice2 instanceof AudioDevice.Speakerphone)) break block2;
            this.getAudioDeviceManager$audioswitch_release().enableSpeakerphone(true);
            BluetoothHeadsetManager bluetoothHeadsetManager = this.headsetManager;
            if (bluetoothHeadsetManager != null) {
                bluetoothHeadsetManager.deactivate();
            }
        }
    }

    @Override
    protected void onDeactivate() {
        block0: {
            BluetoothHeadsetManager bluetoothHeadsetManager = this.headsetManager;
            if (bluetoothHeadsetManager == null) break block0;
            bluetoothHeadsetManager.deactivate();
        }
    }

    @JvmOverloads
    public LegacyAudioSwitch(@NotNull Context context, boolean loggingEnabled, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener, @NotNull List<? extends Class<? extends AudioDevice>> preferredDeviceList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        Intrinsics.checkNotNullParameter(preferredDeviceList, (String)"preferredDeviceList");
        this(context, audioFocusChangeListener, new ProductionLogger(loggingEnabled), preferredDeviceList, null, null, null, null, null, 496, null);
    }

    public /* synthetic */ LegacyAudioSwitch(Context context, boolean bl, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            onAudioFocusChangeListener = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            list = AbstractAudioSwitch.Companion.getDefaultPreferredDeviceList$audioswitch_release();
        }
        this(context, bl, onAudioFocusChangeListener, list);
    }

    @JvmOverloads
    public LegacyAudioSwitch(@NotNull Context context, boolean loggingEnabled, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener) {
        this(context, loggingEnabled, audioFocusChangeListener, null, 8, null);
    }

    @JvmOverloads
    public LegacyAudioSwitch(@NotNull Context context, boolean loggingEnabled) {
        this(context, loggingEnabled, null, null, 12, null);
    }

    @JvmOverloads
    public LegacyAudioSwitch(@NotNull Context context) {
        this(context, false, null, null, 14, null);
    }

    @VisibleForTesting(otherwise=2)
    public LegacyAudioSwitch(@NotNull Context context, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener, @NotNull Logger logger, @NotNull List<? extends Class<? extends AudioDevice>> preferredDeviceList, @NotNull AudioManager audioManager, @NotNull AudioDeviceManager audioDeviceManager, @NotNull WiredHeadsetReceiver wiredHeadsetReceiver, @Nullable BluetoothHeadsetManager headsetManager, @NotNull Scanner scanner) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(preferredDeviceList, (String)"preferredDeviceList");
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkNotNullParameter((Object)((Object)wiredHeadsetReceiver), (String)"wiredHeadsetReceiver");
        Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
        super(context, audioFocusChangeListener, scanner, logger.getLoggingEnabled(), logger, preferredDeviceList, audioDeviceManager);
        this.headsetManager = headsetManager;
    }

    public /* synthetic */ LegacyAudioSwitch(Context context, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, Logger logger, List list, AudioManager audioManager, AudioDeviceManager audioDeviceManager, WiredHeadsetReceiver wiredHeadsetReceiver, BluetoothHeadsetManager bluetoothHeadsetManager, Scanner scanner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Object object = context.getSystemService("audio");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
            }
            audioManager = (AudioManager)object;
        }
        if ((n & 0x20) != 0) {
            audioDeviceManager = new AudioDeviceManager(context, logger, audioManager, null, null, onAudioFocusChangeListener, 24, null);
        }
        if ((n & 0x40) != 0) {
            wiredHeadsetReceiver = new WiredHeadsetReceiver(context, logger);
        }
        if ((n & 0x80) != 0) {
            bluetoothHeadsetManager = BluetoothHeadsetManager.Companion.newInstance$audioswitch_release(context, logger, BluetoothAdapter.getDefaultAdapter(), audioDeviceManager);
        }
        if ((n & 0x100) != 0) {
            scanner = new LegacyAudioDeviceScanner(audioManager, audioDeviceManager, wiredHeadsetReceiver, bluetoothHeadsetManager);
        }
        this(context, onAudioFocusChangeListener, logger, list, audioManager, audioDeviceManager, wiredHeadsetReceiver, bluetoothHeadsetManager, scanner);
    }
}

