/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.twilio.audioswitch.AbstractAudioSwitch;
import com.twilio.audioswitch.AudioDevice;
import com.twilio.audioswitch.AudioDeviceManager;
import com.twilio.audioswitch.android.Logger;
import com.twilio.audioswitch.android.ProductionLogger;
import com.twilio.audioswitch.scanners.AudioDeviceScanner;
import com.twilio.audioswitch.scanners.Scanner;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B;\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u00a2\u0006\u0002\u0010\fB]\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\t\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0014J\b\u0010\u001b\u001a\u00020\u0019H\u0014J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/twilio/audioswitch/AudioSwitch;", "Lcom/twilio/audioswitch/AbstractAudioSwitch;", "context", "Landroid/content/Context;", "loggingEnabled", "", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "preferredDeviceList", "", "Ljava/lang/Class;", "Lcom/twilio/audioswitch/AudioDevice;", "(Landroid/content/Context;ZLandroid/media/AudioManager$OnAudioFocusChangeListener;Ljava/util/List;)V", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioManager", "Landroid/media/AudioManager;", "audioDeviceManager", "Lcom/twilio/audioswitch/AudioDeviceManager;", "handler", "Landroid/os/Handler;", "scanner", "Lcom/twilio/audioswitch/scanners/Scanner;", "(Landroid/content/Context;Landroid/media/AudioManager$OnAudioFocusChangeListener;Lcom/twilio/audioswitch/android/Logger;Ljava/util/List;Landroid/media/AudioManager;Lcom/twilio/audioswitch/AudioDeviceManager;Landroid/os/Handler;Lcom/twilio/audioswitch/scanners/Scanner;)V", "onActivate", "", "audioDevice", "onDeactivate", "onDeviceDisconnected", "audioswitch_release"})
@RequiresApi(value=23)
public final class AudioSwitch
extends AbstractAudioSwitch {
    @Override
    public void onDeviceDisconnected(@NotNull AudioDevice audioDevice) {
        Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
        this.getLogger$audioswitch_release().d("AudioSwitch", "onDeviceDisconnected(" + audioDevice + ')');
        boolean wasChanged = this.getAvailableUniqueAudioDevices().remove(audioDevice);
        if (Intrinsics.areEqual((Object)this.getUserSelectedAudioDevice(), (Object)audioDevice)) {
            this.setUserSelectedAudioDevice(null);
        }
        if (audioDevice instanceof AudioDevice.WiredHeadset && this.getAudioDeviceManager$audioswitch_release().hasEarpiece()) {
            wasChanged = this.getAvailableUniqueAudioDevices().add(new AudioDevice.Earpiece(null, 1, null)) || wasChanged;
        }
        AbstractAudioSwitch.selectAudioDevice$default(this, wasChanged, null, 2, null);
    }

    @Override
    protected void onActivate(@NotNull AudioDevice audioDevice) {
        block1: {
            AudioDevice audioDevice2;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)audioDevice, (String)"audioDevice");
                    this.getLogger$audioswitch_release().d("AudioSwitch", "onActivate(" + audioDevice + ')');
                    audioDevice2 = audioDevice;
                    if (!(audioDevice2 instanceof AudioDevice.BluetoothHeadset)) break block0;
                    this.getAudioDeviceManager$audioswitch_release().enableSpeakerphone(false);
                    this.getAudioDeviceManager$audioswitch_release().enableBluetoothSco(true);
                    break block1;
                }
                if (!(audioDevice2 instanceof AudioDevice.Earpiece) && !(audioDevice2 instanceof AudioDevice.WiredHeadset)) break block2;
                this.getAudioDeviceManager$audioswitch_release().enableSpeakerphone(false);
                this.getAudioDeviceManager$audioswitch_release().enableBluetoothSco(false);
                break block1;
            }
            if (!(audioDevice2 instanceof AudioDevice.Speakerphone)) break block1;
            this.getAudioDeviceManager$audioswitch_release().enableBluetoothSco(false);
            this.getAudioDeviceManager$audioswitch_release().enableSpeakerphone(true);
        }
    }

    @Override
    protected void onDeactivate() {
        this.getLogger$audioswitch_release().d("AudioSwitch", "onDeactivate");
        if (this.getSelectedAudioDevice() instanceof AudioDevice.BluetoothHeadset) {
            this.getAudioDeviceManager$audioswitch_release().enableBluetoothSco(false);
        }
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, boolean loggingEnabled, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener, @NotNull List<? extends Class<? extends AudioDevice>> preferredDeviceList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        Intrinsics.checkNotNullParameter(preferredDeviceList, (String)"preferredDeviceList");
        this(context, audioFocusChangeListener, new ProductionLogger(loggingEnabled), preferredDeviceList, null, null, null, null, 240, null);
    }

    public /* synthetic */ AudioSwitch(Context context, boolean bl, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            onAudioFocusChangeListener = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            list = AbstractAudioSwitch.Companion.getDefaultPreferredDeviceList$audioswitch_release();
        }
        this(context, bl, onAudioFocusChangeListener, list);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, boolean loggingEnabled, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener) {
        this(context, loggingEnabled, audioFocusChangeListener, null, 8, null);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context, boolean loggingEnabled) {
        this(context, loggingEnabled, null, null, 12, null);
    }

    @JvmOverloads
    public AudioSwitch(@NotNull Context context) {
        this(context, false, null, null, 14, null);
    }

    @VisibleForTesting(otherwise=2)
    public AudioSwitch(@NotNull Context context, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener, @NotNull Logger logger, @NotNull List<? extends Class<? extends AudioDevice>> preferredDeviceList, @NotNull AudioManager audioManager, @NotNull AudioDeviceManager audioDeviceManager, @NotNull Handler handler, @NotNull Scanner scanner) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(preferredDeviceList, (String)"preferredDeviceList");
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        Intrinsics.checkNotNullParameter((Object)audioDeviceManager, (String)"audioDeviceManager");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
        super(context, audioFocusChangeListener, scanner, false, logger, preferredDeviceList, audioDeviceManager, 8, null);
    }

    public /* synthetic */ AudioSwitch(Context context, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, Logger logger, List list, AudioManager audioManager, AudioDeviceManager audioDeviceManager, Handler handler, Scanner scanner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Object object = context.getSystemService("audio");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.media.AudioManager");
            }
            audioManager = (AudioManager)object;
        }
        if ((n & 0x20) != 0) {
            audioDeviceManager = new AudioDeviceManager(context, logger, audioManager, null, null, onAudioFocusChangeListener, 24, null);
        }
        if ((n & 0x40) != 0) {
            handler = new Handler(Looper.getMainLooper());
        }
        if ((n & 0x80) != 0) {
            scanner = new AudioDeviceScanner(audioManager, handler);
        }
        this(context, onAudioFocusChangeListener, logger, list, audioManager, audioDeviceManager, handler, scanner);
    }
}

