/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.audioswitch;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import androidx.annotation.RequiresApi;
import com.twilio.audioswitch.AudioFocusRequestWrapper;
import com.twilio.audioswitch.android.BuildWrapper;
import com.twilio.audioswitch.android.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020%J\u000e\u0010+\u001a\u00020(2\u0006\u0010*\u001a\u00020%J\u0006\u0010,\u001a\u00020%J\b\u0010-\u001a\u00020%H\u0007J\u000e\u0010.\u001a\u00020(2\u0006\u0010.\u001a\u00020%J\b\u0010/\u001a\u00020(H\u0007J\b\u00100\u001a\u00020(H\u0007R\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0012\"\u0004\b\u001f\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/twilio/audioswitch/AudioDeviceManager;", "", "context", "Landroid/content/Context;", "logger", "Lcom/twilio/audioswitch/android/Logger;", "audioManager", "Landroid/media/AudioManager;", "build", "Lcom/twilio/audioswitch/android/BuildWrapper;", "audioFocusRequest", "Lcom/twilio/audioswitch/AudioFocusRequestWrapper;", "audioFocusChangeListener", "Landroid/media/AudioManager$OnAudioFocusChangeListener;", "(Landroid/content/Context;Lcom/twilio/audioswitch/android/Logger;Landroid/media/AudioManager;Lcom/twilio/audioswitch/android/BuildWrapper;Lcom/twilio/audioswitch/AudioFocusRequestWrapper;Landroid/media/AudioManager$OnAudioFocusChangeListener;)V", "audioAttributeContentType", "", "getAudioAttributeContentType", "()I", "setAudioAttributeContentType", "(I)V", "audioAttributeUsageType", "getAudioAttributeUsageType", "setAudioAttributeUsageType", "audioMode", "getAudioMode", "setAudioMode", "audioRequest", "Landroid/media/AudioFocusRequest;", "audioStreamType", "getAudioStreamType", "setAudioStreamType", "focusMode", "getFocusMode", "setFocusMode", "savedAudioMode", "savedIsMicrophoneMuted", "", "savedSpeakerphoneEnabled", "cacheAudioState", "", "enableBluetoothSco", "enable", "enableSpeakerphone", "hasEarpiece", "hasSpeakerphone", "mute", "restoreAudioState", "setAudioFocus", "audioswitch_release"})
public final class AudioDeviceManager {
    private int savedAudioMode;
    private boolean savedIsMicrophoneMuted;
    private boolean savedSpeakerphoneEnabled;
    private AudioFocusRequest audioRequest;
    private int audioMode;
    private int focusMode;
    private int audioStreamType;
    @RequiresApi(value=21)
    private int audioAttributeUsageType;
    @RequiresApi(value=21)
    private int audioAttributeContentType;
    private final Context context;
    private final Logger logger;
    private final AudioManager audioManager;
    private final BuildWrapper build;
    private final AudioFocusRequestWrapper audioFocusRequest;
    private final AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;

    public final int getAudioMode() {
        return this.audioMode;
    }

    public final void setAudioMode(int n) {
        this.audioMode = n;
    }

    public final int getFocusMode() {
        return this.focusMode;
    }

    public final void setFocusMode(int n) {
        this.focusMode = n;
    }

    public final int getAudioStreamType() {
        return this.audioStreamType;
    }

    public final void setAudioStreamType(int n) {
        this.audioStreamType = n;
    }

    public final int getAudioAttributeUsageType() {
        return this.audioAttributeUsageType;
    }

    public final void setAudioAttributeUsageType(int n) {
        this.audioAttributeUsageType = n;
    }

    public final int getAudioAttributeContentType() {
        return this.audioAttributeContentType;
    }

    public final void setAudioAttributeContentType(int n) {
        this.audioAttributeContentType = n;
    }

    public final boolean hasEarpiece() {
        boolean hasEarpiece = this.context.getPackageManager().hasSystemFeature("android.hardware.telephony");
        if (hasEarpiece) {
            this.logger.d("AudioDeviceManager", "Earpiece available");
        }
        return hasEarpiece;
    }

    @SuppressLint(value={"NewApi"})
    public final boolean hasSpeakerphone() {
        boolean bl;
        if (this.build.getVersion() >= 23 && this.context.getPackageManager().hasSystemFeature("android.hardware.audio.output")) {
            AudioDeviceInfo[] devices;
            AudioDeviceInfo[] audioDeviceInfoArray = devices = this.audioManager.getDevices(2);
            int n = audioDeviceInfoArray.length;
            for (int i = 0; i < n; ++i) {
                AudioDeviceInfo device;
                AudioDeviceInfo audioDeviceInfo = device = audioDeviceInfoArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)audioDeviceInfo, (String)"device");
                if (audioDeviceInfo.getType() != 2) continue;
                this.logger.d("AudioDeviceManager", "Speakerphone available");
                return true;
            }
            bl = false;
        } else {
            this.logger.d("AudioDeviceManager", "Speakerphone available");
            bl = true;
        }
        return bl;
    }

    @SuppressLint(value={"NewApi"})
    public final void setAudioFocus() {
        if (this.build.getVersion() >= 26) {
            AudioFocusRequest audioFocusRequest = this.audioRequest = this.audioFocusRequest.buildRequest(this.audioFocusChangeListener, this.focusMode, this.audioAttributeUsageType, this.audioAttributeContentType);
            if (audioFocusRequest != null) {
                AudioFocusRequest audioFocusRequest2 = audioFocusRequest;
                boolean bl = false;
                boolean bl2 = false;
                AudioFocusRequest it = audioFocusRequest2;
                boolean bl3 = false;
                this.audioManager.requestAudioFocus(it);
            }
        } else {
            this.audioManager.requestAudioFocus(this.audioFocusChangeListener, this.audioStreamType, this.focusMode);
        }
        this.audioManager.setMode(this.audioMode);
    }

    public final void enableBluetoothSco(boolean enable) {
        AudioManager audioManager = this.audioManager;
        boolean bl = false;
        boolean bl2 = false;
        AudioManager $this$run = audioManager;
        boolean bl3 = false;
        if (enable) {
            $this$run.startBluetoothSco();
        } else {
            $this$run.stopBluetoothSco();
        }
    }

    public final void enableSpeakerphone(boolean enable) {
        this.audioManager.setSpeakerphoneOn(enable);
    }

    public final void mute(boolean mute) {
        this.audioManager.setMicrophoneMute(mute);
    }

    public final void cacheAudioState() {
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsMicrophoneMuted = this.audioManager.isMicrophoneMute();
        this.savedSpeakerphoneEnabled = this.audioManager.isSpeakerphoneOn();
    }

    @SuppressLint(value={"NewApi"})
    public final void restoreAudioState() {
        this.audioManager.setMode(this.savedAudioMode);
        this.mute(this.savedIsMicrophoneMuted);
        this.enableSpeakerphone(this.savedSpeakerphoneEnabled);
        if (this.build.getVersion() >= 26) {
            AudioFocusRequest audioFocusRequest = this.audioRequest;
            if (audioFocusRequest != null) {
                AudioFocusRequest audioFocusRequest2 = audioFocusRequest;
                boolean bl = false;
                boolean bl2 = false;
                AudioFocusRequest it = audioFocusRequest2;
                boolean bl3 = false;
                this.audioManager.abandonAudioFocusRequest(it);
            }
            this.audioRequest = null;
        } else {
            this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        }
    }

    public AudioDeviceManager(@NotNull Context context, @NotNull Logger logger, @NotNull AudioManager audioManager, @NotNull BuildWrapper build, @NotNull AudioFocusRequestWrapper audioFocusRequest, @NotNull AudioManager.OnAudioFocusChangeListener audioFocusChangeListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)audioManager, (String)"audioManager");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)audioFocusRequest, (String)"audioFocusRequest");
        Intrinsics.checkNotNullParameter((Object)audioFocusChangeListener, (String)"audioFocusChangeListener");
        this.context = context;
        this.logger = logger;
        this.audioManager = audioManager;
        this.build = build;
        this.audioFocusRequest = audioFocusRequest;
        this.audioFocusChangeListener = audioFocusChangeListener;
        this.audioMode = 3;
        this.focusMode = 2;
        this.audioAttributeUsageType = 2;
        this.audioAttributeContentType = 1;
    }

    public /* synthetic */ AudioDeviceManager(Context context, Logger logger, AudioManager audioManager, BuildWrapper buildWrapper, AudioFocusRequestWrapper audioFocusRequestWrapper, AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            buildWrapper = new BuildWrapper();
        }
        if ((n & 0x10) != 0) {
            audioFocusRequestWrapper = new AudioFocusRequestWrapper();
        }
        this(context, logger, audioManager, buildWrapper, audioFocusRequestWrapper, onAudioFocusChangeListener);
    }
}

