/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.github.davidfantasy.mybatisplus.generatorui.GeneratorConfig;
import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.dto.DtoFieldInfo;
import com.github.davidfantasy.mybatisplus.generatorui.dto.ElementPosition;
import com.github.davidfantasy.mybatisplus.generatorui.dto.GenDtoConfig;
import com.github.davidfantasy.mybatisplus.generatorui.dto.GenDtoFromSqlReq;
import com.github.davidfantasy.mybatisplus.generatorui.dto.JavaClassMethodInfo;
import com.github.davidfantasy.mybatisplus.generatorui.dto.MapperElement;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.BeetlTemplateEngine;
import com.github.davidfantasy.mybatisplus.generatorui.service.JavaClassParser;
import com.github.davidfantasy.mybatisplus.generatorui.service.MapperXmlParser;
import com.github.davidfantasy.mybatisplus.generatorui.sqlparser.ConditionExpr;
import com.github.davidfantasy.mybatisplus.generatorui.sqlparser.DynamicParamSqlEnhancer;
import com.github.davidfantasy.mybatisplus.generatorui.util.PathUtil;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Service;

@Service
public class SqlGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(SqlGeneratorService.class);
    final Base64.Decoder decoder = Base64.getDecoder();
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private GeneratorConfig generatorConfig;
    @Autowired
    private BeetlTemplateEngine beetlTemplateEngine;
    @Autowired
    private ProjectPathResolver projectPathResolver;
    @Autowired
    private DataSourceConfig dataSourceConfig;
    @Autowired
    private MapperXmlParser mapperXmlParser;
    @Autowired
    private DynamicParamSqlEnhancer dynamicParamSqlEnhancer;
    @Autowired
    private JavaClassParser javaClassParser;
    private List<String> rangeOperators = Lists.newArrayList((Object[])new String[]{"BETWEEN", "<", "<=", ">", ">="});

    public void genMapperMethod(GenDtoFromSqlReq params) throws Exception {
        if (Strings.isNullOrEmpty((String)params.getSql())) {
            throw new ServiceException("\u6570\u636e\u6e90SQL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String decodedSql = new String(this.decoder.decode(params.getSql()), "UTF-8");
        if (!decodedSql.trim().toLowerCase().startsWith("select")) {
            throw new ServiceException("\u53ea\u80fd\u901a\u8fc7\u67e5\u8be2\u8bed\u53e5\u751f\u6210DTO\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5SQL");
        }
        if (!Strings.isNullOrEmpty((String)params.getConfig().getFullPackage())) {
            try {
                Class.forName(params.getConfig().getFullPackage());
            }
            catch (Throwable t) {
                params.getConfig().setAutoCreatedResultDto(true);
            }
        }
        if (params.getConfig().isAutoCreatedResultDto()) {
            this.genDtoFileFromSQL(decodedSql, params.getConfig());
        }
        String namespace = this.genMapperElementsFromSql(decodedSql, params.getConfig());
        if (params.getConfig().getEnableCreateDaoMethod().booleanValue()) {
            if ("bean".equals(params.getConfig().getDaoMethodParamType())) {
                this.genParamDtoFromSql(decodedSql, params.getConfig().getDaoMethodParamDto(), params.getConfig().isEnableLombok());
            }
            this.addDaoMethod(namespace, decodedSql, params.getConfig());
        }
    }

    public void genDtoFileFromSQL(String sql, GenDtoConfig config) throws Exception {
        sql = this.dynamicParamSqlEnhancer.clearIllegalStatements(sql);
        SqlRowSet rowSet = null;
        try {
            rowSet = this.jdbcTemplate.queryForRowSet(sql);
        }
        catch (Exception e) {
            log.error("\u6267\u884cSQL\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new ServiceException("\u6267\u884cSQL\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        SqlRowSetMetaData metaData = rowSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList fields = Lists.newArrayList();
        GlobalConfig.Builder gb = new GlobalConfig.Builder();
        GlobalConfig gc = gb.dateType(this.generatorConfig.getDateType()).build();
        for (int i = 1; i <= columnCount; ++i) {
            DtoFieldInfo resultField = new DtoFieldInfo();
            resultField.setColumnName(metaData.getColumnLabel(i));
            String colType = metaData.getColumnTypeName(i);
            IColumnType columnType = this.dataSourceConfig.getTypeConvert().processTypeConvert(gc, metaData.getColumnTypeName(i));
            resultField.setShortJavaType(columnType.getType());
            if (!Strings.isNullOrEmpty((String)columnType.getPkg())) {
                config.getImportPackages().add(columnType.getPkg());
            }
            resultField.setPropertyName(this.generatorConfig.getAvailableNameConverter().propertyNameConvert(resultField.getColumnName()));
            fields.add(resultField);
        }
        config.setFields(fields);
        config.setCreateDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        if (!Strings.isNullOrEmpty((String)config.getMapperLocation())) {
            config.setComment(config.getMapperLocation() + "\u7684\u67e5\u8be2\u7ed3\u679c\u96c6\uff0c\u8be5\u4ee3\u7801\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210");
        } else {
            config.setComment("\u8be5\u4ee3\u7801\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210");
        }
        this.genDtoFromConfig(config);
    }

    public String genMapperElementsFromSql(String sql, GenDtoConfig config) throws IOException, DocumentException {
        ArrayList elements = Lists.newArrayList();
        if (config.getResultMap() != null) {
            elements.add(this.createResultMapElement(config));
        }
        elements.add(this.createMapperMethodElement(sql, config));
        String mapperPath = this.projectPathResolver.convertPackageToPath(config.getMapperPackage()) + ".xml";
        String namespace = this.mapperXmlParser.addElementInMapper(mapperPath, elements.toArray(new MapperElement[0]));
        log.info("ResultMap\u548cMapper\u65b9\u6cd5\u5df2\u751f\u6210\uff0c\u8f93\u51fa\u4f4d\u7f6e\u4e3a:" + mapperPath);
        return namespace;
    }

    public MapperElement createResultMapElement(GenDtoConfig config) {
        HashMap tplParams = Maps.newHashMap();
        tplParams.put("config", config);
        String resultMapStr = this.beetlTemplateEngine.write2String(tplParams, "classpath:codetpls/resultMap.btl");
        MapperElement resultMapEle = MapperElement.builder().id(config.getDtoName() + "Map").comment("Author:" + config.getAuthor() + "\uff0cDate:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + "\uff0c" + config.getMapperElementId() + "\u7684\u7ed3\u679c\u6620\u5c04\u914d\u7f6e\uff0c\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210").content(resultMapStr).location(ElementPosition.FIRST).build();
        return resultMapEle;
    }

    public MapperElement createMapperMethodElement(String sql, GenDtoConfig config) {
        HashMap tplParams = Maps.newHashMap();
        String dbType = this.dataSourceConfig.getDbType().getDb();
        tplParams.put("config", config);
        tplParams.put("elementType", "select");
        if (config.isEnableParseDynamicParams()) {
            sql = this.dynamicParamSqlEnhancer.enhanceDynamicConditions(sql);
        }
        tplParams.put("sql", sql);
        String methodEleStr = this.beetlTemplateEngine.write2String(tplParams, "classpath:codetpls/mapperMethods.btl");
        MapperElement methodEle = MapperElement.builder().id(config.getMapperElementId()).comment("Author:" + config.getAuthor() + "\uff0cDate:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + ",\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210").content(methodEleStr).location(ElementPosition.LAST).build();
        return methodEle;
    }

    public void genParamDtoFromSql(String sql, String paramDtoRef, boolean enableLombok) throws Exception {
        List<ConditionExpr> conditionExprs = this.dynamicParamSqlEnhancer.parseSqlDynamicConditions(sql);
        if (conditionExprs.isEmpty()) {
            log.info("\u672a\u68c0\u6d4b\u5230SQL\u7684\u52a8\u6001\u53c2\u6570\uff0c\u5ffd\u7565\u53c2\u6570DTO\u7684\u751f\u6210");
            return;
        }
        List<DtoFieldInfo> fields = this.parseParamFieldsFromSql(sql);
        GenDtoConfig config = new GenDtoConfig();
        config.setEnableLombok(enableLombok);
        for (DtoFieldInfo fi : fields) {
            config.getImportPackages().addAll(fi.getImportJavaTypes());
        }
        config.setFullPackage(paramDtoRef);
        config.setFields(fields);
        config.setCreateDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        if (!Strings.isNullOrEmpty((String)config.getMapperLocation())) {
            config.setComment(config.getMapperLocation() + "\u7684\u67e5\u8be2\u53c2\u6570Bean\uff0c\u8be5\u4ee3\u7801\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210");
        } else {
            config.setComment("\u8be5\u4ee3\u7801\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210");
        }
        this.genDtoFromConfig(config);
    }

    public void addDaoMethod(String daoClassRef, String sql, GenDtoConfig config) throws Exception {
        List<DtoFieldInfo> sqlConditions;
        HashSet imports = Sets.newHashSet();
        List<Object> methodParams = Lists.newArrayList();
        String returnType = "";
        if (!Strings.isNullOrEmpty((String)config.getFullPackage())) {
            imports.add("java.util.List");
            imports.add(config.getFullPackage());
            returnType = "List<" + PathUtil.getShortNameFromFullRef(config.getFullPackage()) + ">";
        } else {
            imports.add("java.util.List");
            imports.add("java.util.Map");
            returnType = "List<Map<String,Object>>";
        }
        if (config.isEnablePageQuery()) {
            imports.add("com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            returnType = returnType.replaceFirst("List", "Page");
            DtoFieldInfo param = new DtoFieldInfo();
            param.setShortJavaType(PathUtil.getShortNameFromFullRef(returnType));
            param.setPropertyName("pageParam");
            methodParams.add(param);
        }
        if (!(sqlConditions = this.parseParamFieldsFromSql(sql)).isEmpty()) {
            Object param;
            if ("map".equals(config.getDaoMethodParamType())) {
                param = new DtoFieldInfo();
                ((DtoFieldInfo)param).setShortJavaType("Map<String,Object>");
                ((DtoFieldInfo)param).setPropertyName("params");
                ((DtoFieldInfo)param).addImportJavaType("java.util.Map");
                methodParams.add(param);
            } else if ("bean".equals(config.getDaoMethodParamType())) {
                param = new DtoFieldInfo();
                ((DtoFieldInfo)param).setShortJavaType(PathUtil.getShortNameFromFullRef(config.getDaoMethodParamDto()));
                ((DtoFieldInfo)param).setPropertyName("params");
                ((DtoFieldInfo)param).addImportJavaType(config.getDaoMethodParamDto());
                methodParams.add(param);
            } else {
                for (DtoFieldInfo dtoFieldInfo : sqlConditions) {
                    NodeList annotations = new NodeList();
                    SingleMemberAnnotationExpr paramAnno = new SingleMemberAnnotationExpr(new Name("Param"), (Expression)new StringLiteralExpr(dtoFieldInfo.getPropertyName()));
                    annotations.add((Node)paramAnno);
                    dtoFieldInfo.setAnnotations((NodeList<AnnotationExpr>)annotations);
                    dtoFieldInfo.addImportJavaType("org.apache.ibatis.annotations.Param");
                }
                methodParams = sqlConditions;
            }
        }
        for (DtoFieldInfo dtoFieldInfo : methodParams) {
            if (dtoFieldInfo.getImportJavaTypes() == null) continue;
            imports.addAll(dtoFieldInfo.getImportJavaTypes());
        }
        JavaClassMethodInfo methodInfo = JavaClassMethodInfo.builder().classRef(daoClassRef).methodName(config.getMapperMethod()).returnType(returnType).importJavaTypes(imports).params((List<DtoFieldInfo>)methodParams).build();
        this.javaClassParser.addMethod2Interface(methodInfo);
    }

    private List<DtoFieldInfo> parseParamFieldsFromSql(String sql) {
        List<ConditionExpr> conditionExprs = this.dynamicParamSqlEnhancer.parseSqlDynamicConditions(sql);
        if (conditionExprs.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList fields = Lists.newArrayList();
        for (ConditionExpr expr : conditionExprs) {
            for (String paramName : expr.getParamNames()) {
                DbColumnType cType;
                boolean isDate;
                DtoFieldInfo field = new DtoFieldInfo();
                field.setPropertyName(PathUtil.getShortNameFromFullRef(paramName));
                boolean bl = isDate = paramName.toLowerCase().endsWith("date") || paramName.toLowerCase().endsWith("time");
                if (expr.getOperator().toUpperCase().equals("IN")) {
                    cType = DbColumnType.STRING;
                    if (isDate) {
                        cType = this.getRightDateType(this.generatorConfig.getDateType());
                        field.addImportJavaType(cType.getPkg());
                    }
                    field.setShortJavaType("List<" + cType.getType() + ">");
                    field.addImportJavaType("java.util.List");
                } else if (this.rangeOperators.contains(expr.getOperator().toUpperCase())) {
                    cType = DbColumnType.LONG;
                    if (isDate) {
                        cType = this.getRightDateType(this.generatorConfig.getDateType());
                        field.addImportJavaType(cType.getPkg());
                    }
                    field.setShortJavaType(cType.getType());
                } else {
                    field.setShortJavaType("String");
                }
                fields.add(field);
            }
        }
        return fields;
    }

    private void genDtoFromConfig(GenDtoConfig config) throws Exception {
        HashMap tplParams = Maps.newHashMap();
        tplParams.put("config", config);
        String outputPath = this.projectPathResolver.convertPackageToPath(config.getFullPackage()) + ".java";
        File file = new File(outputPath);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        this.beetlTemplateEngine.writer(tplParams, "classpath:codetpls/dto.btl", new File(outputPath));
        log.info("DTO\u5df2\u6210\u529f\u751f\u6210\uff0c\u8f93\u51fa\u4f4d\u7f6e\u4e3a:" + outputPath);
    }

    private DbColumnType getRightDateType(DateType dateType) {
        switch (dateType) {
            case ONLY_DATE: {
                return DbColumnType.DATE;
            }
            case SQL_PACK: {
                return DbColumnType.DATE_SQL;
            }
            case TIME_PACK: {
                return DbColumnType.LOCAL_DATE;
            }
        }
        return null;
    }
}

