/*
 * Decompiled with CFR 0.152.
 */
package com.datalogic.device.input;

public enum DLKeyEvent {
    KEYCODE_UNKNOWN(0),
    KEYCODE_BARCODE(180),
    KEYCODE_SCANNER_INPUT_SWITCH(1126),
    KEYCODE_PUSH_TO_TALK(1127),
    KEYCODE_BATTERY_SWAP(1128),
    KEYCODE_OCR_DECODE(1129),
    KEYCODE_SOS(1130);

    private final int val;
    private static final DLKeyEvent[] ALL_VALUES;

    private DLKeyEvent(int val) {
        this.val = val;
    }

    public int getKeyCodeValue() {
        return this.val;
    }

    public static DLKeyEvent getKeyCodeType(int value) {
        for (int i = 0; i < ALL_VALUES.length; ++i) {
            if (DLKeyEvent.ALL_VALUES[i].val != value) continue;
            return ALL_VALUES[i];
        }
        return KEYCODE_UNKNOWN;
    }

    public static DLKeyEvent[] getAvailableDLKeyEvents() {
        return ALL_VALUES;
    }

    static {
        ALL_VALUES = DLKeyEvent.values();
    }
}

