/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables.qrepository;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.datatables.PredicateBuilder;
import org.springframework.data.jpa.datatables.mapping.DataTablesInput;
import org.springframework.data.jpa.datatables.mapping.DataTablesOutput;
import org.springframework.data.jpa.datatables.qrepository.QDataTablesRepository;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.QueryDslJpaRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.SimpleEntityPathResolver;

public class QDataTablesRepositoryImpl<T, ID extends Serializable>
extends QueryDslJpaRepository<T, ID>
implements QDataTablesRepository<T, ID> {
    private static final EntityPathResolver DEFAULT_ENTITY_PATH_RESOLVER = SimpleEntityPathResolver.INSTANCE;
    private final EntityPath<T> path;
    private final PathBuilder<T> builder;

    QDataTablesRepositoryImpl(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        this(entityInformation, entityManager, DEFAULT_ENTITY_PATH_RESOLVER);
    }

    public QDataTablesRepositoryImpl(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager, EntityPathResolver resolver) {
        super(entityInformation, entityManager);
        this.path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(this.path.getType(), this.path.getMetadata());
    }

    @Override
    public DataTablesOutput<T> findAll(DataTablesInput input) {
        return this.findAll(input, null, null, null);
    }

    @Override
    public DataTablesOutput<T> findAll(DataTablesInput input, Predicate additionalPredicate) {
        return this.findAll(input, additionalPredicate, null, null);
    }

    @Override
    public DataTablesOutput<T> findAll(DataTablesInput input, Predicate additionalPredicate, Predicate preFilteringPredicate) {
        return this.findAll(input, additionalPredicate, preFilteringPredicate, null);
    }

    @Override
    public <R> DataTablesOutput<R> findAll(DataTablesInput input, Converter<T, R> converter) {
        return this.findAll(input, null, null, converter);
    }

    @Override
    public <R> DataTablesOutput<R> findAll(DataTablesInput input, Predicate additionalPredicate, Predicate preFilteringPredicate, Converter<T, R> converter) {
        DataTablesOutput output = new DataTablesOutput();
        output.setDraw(input.getDraw());
        if (input.getLength() == 0) {
            return output;
        }
        try {
            long recordsTotal;
            long l = recordsTotal = preFilteringPredicate == null ? this.count() : this.count(preFilteringPredicate);
            if (recordsTotal == 0L) {
                return output;
            }
            output.setRecordsTotal(recordsTotal);
            PredicateBuilder predicateBuilder = new PredicateBuilder(this.builder, input);
            Page data = this.findAll(new BooleanBuilder().and(predicateBuilder.build()).and(additionalPredicate).and(preFilteringPredicate).getValue(), predicateBuilder.createPageable());
            List content = converter == null ? data.getContent() : data.map(converter).getContent();
            output.setData(content);
            output.setRecordsFiltered(data.getTotalElements());
        }
        catch (Exception e) {
            output.setError(e.toString());
        }
        return output;
    }
}

