/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables.qrepository;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.datatables.qrepository.QDataTablesRepository;
import org.springframework.data.jpa.datatables.qrepository.QDataTablesRepositoryImpl;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class QDataTablesRepositoryFactoryBean<R extends JpaRepository<T, ID>, T, ID extends Serializable>
extends JpaRepositoryFactoryBean<R, T, ID> {
    public QDataTablesRepositoryFactoryBean(Class<? extends R> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new DataTablesRepositoryFactory(entityManager);
    }

    private static class DataTablesRepositoryFactory<T, ID extends Serializable>
    extends JpaRepositoryFactory {
        public DataTablesRepositoryFactory(EntityManager entityManager) {
            super(entityManager);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            Class repositoryInterface = metadata.getRepositoryInterface();
            if (QDataTablesRepository.class.isAssignableFrom(repositoryInterface)) {
                return QDataTablesRepositoryImpl.class;
            }
            return super.getRepositoryBaseClass(metadata);
        }
    }
}

