/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables;

import java.util.ArrayList;
import java.util.List;

class Node<T> {
    private final String name;
    private final T data;
    private List<Node<T>> children = new ArrayList<Node<T>>();

    Node(String name, T data) {
        this.name = name;
        this.data = data;
    }

    Node(String name) {
        this.name = name;
        this.data = null;
    }

    void addChild(Node<T> child) {
        this.children.add(child);
    }

    Node<T> getOrCreateChild(String name) {
        for (Node<T> child : this.children) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        Node<T> child = new Node<T>(name);
        this.children.add(child);
        return child;
    }

    boolean isLeaf() {
        return this.children.isEmpty();
    }

    public T getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    List<Node<T>> getChildren() {
        return this.children;
    }
}

