/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.datatables;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringOperation;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.datatables.Filter;

class GlobalFilter
implements Filter {
    private final String escapedRawValue;

    GlobalFilter(String filterValue) {
        this.escapedRawValue = this.escapeValue(filterValue);
    }

    String nullOrTrimmedValue(String value) {
        return "\\NULL".equals(value) ? "NULL" : value.trim();
    }

    private String escapeValue(String filterValue) {
        return "%" + this.nullOrTrimmedValue(filterValue).toLowerCase().replaceAll("~", "~~").replaceAll("%", "~%").replaceAll("_", "~_") + "%";
    }

    @Override
    public Predicate createPredicate(From<?, ?> from, CriteriaBuilder criteriaBuilder, String attributeName) {
        Path expression = from.get(attributeName);
        return criteriaBuilder.like(criteriaBuilder.lower(expression.as(String.class)), this.escapedRawValue, '~');
    }

    @Override
    public com.querydsl.core.types.Predicate createPredicate(PathBuilder<?> pathBuilder, String attributeName) {
        StringOperation path = Expressions.stringOperation((Operator)Ops.STRING_CAST, (Expression[])new Expression[]{pathBuilder.get(attributeName)});
        return path.lower().like(this.escapedRawValue, '~');
    }
}

