/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import org.scilab.forge.jlatexmath.core.Box;

public class OverUnderBox
extends Box {
    private final Box base;
    private final Box del;
    private final Box script;
    private final float kern;
    private final boolean over;

    public OverUnderBox(Box b, Box d, Box script, float kern, boolean over) {
        this.base = b;
        this.del = d;
        this.script = script;
        this.kern = kern;
        this.over = over;
        this.width = b.getWidth();
        this.height = b.height + (over ? d.getWidth() : 0.0f) + (over && script != null ? script.height + script.depth + kern : 0.0f);
        this.depth = b.depth + (over ? 0.0f : d.getWidth()) + (!over && script != null ? script.height + script.depth + kern : 0.0f);
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        float transY;
        float transX;
        g2.save();
        this.drawDebug(g2, x, y);
        this.base.draw(g2, x, y);
        float yVar = y - this.base.height - this.del.getWidth();
        this.del.setDepth(this.del.getHeight() + this.del.getDepth());
        this.del.setHeight(0.0f);
        if (this.over) {
            transX = (float)((double)x + (double)(this.del.height + this.del.depth) * 0.75);
            transY = yVar;
            g2.translate(transX, transY);
            g2.rotate((float)Math.toDegrees(1.5707963267948966));
            this.del.draw(g2, 0.0f, 0.0f);
            g2.restore();
            if (this.script != null) {
                this.script.draw(g2, x, yVar - this.kern - this.script.depth);
            }
        }
        yVar = y + this.base.depth;
        if (!this.over) {
            transX = (float)((double)x + (double)(this.del.getHeight() + this.del.depth) * 0.75);
            transY = yVar;
            g2.translate(transX, transY);
            g2.rotate((float)Math.toDegrees(1.5707963705062866));
            this.del.draw(g2, 0.0f, 0.0f);
            g2.restore();
            yVar += this.del.getWidth();
            if (this.script != null) {
                this.script.draw(g2, x, yVar + this.kern + this.script.height);
            }
        }
    }

    @Override
    public int getLastFontId() {
        return this.base.getLastFontId();
    }
}

