/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.content.res.AssetManager;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import java.awt.font.TextAttribute;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.Box;

public class JavaFontRenderingBox
extends Box {
    private static Typeface font = Typeface.DEFAULT;
    private String str;
    private float size;
    private static TextAttribute KERNING;
    private static Integer KERNING_ON;
    private static TextAttribute LIGATURES;
    private static Integer LIGATURES_ON;

    public JavaFontRenderingBox(String str, int type, float size, Typeface f, boolean kerning) {
        this.str = str;
        this.size = size;
        Paint pFont = new Paint();
        Rect rect = new Rect();
        pFont.getTextBounds(str, 0, str.length(), rect);
        this.height = (float)(-rect.top) * size / 2.0f;
        this.depth = (float)rect.height() * size / 2.0f - this.height;
        this.width = ((float)(rect.width() + rect.right) + 0.4f) * size / 4.0f;
        System.out.println(" width=" + this.width + " height=" + this.height + " text=" + str);
    }

    public JavaFontRenderingBox(String str, int type, float size) {
        this(str, type, size, font, true);
    }

    public static void setFont(String name) {
        AssetManager mng = AjLatexMath.getAssetManager();
        font = Typeface.createFromAsset((AssetManager)mng, (String)name);
    }

    @Override
    public void draw(Canvas g2, float x, float y) {
        this.drawDebug(g2, x, y);
        Paint st = new Paint();
        float w = st.getStrokeWidth();
        Paint.Style s = st.getStyle();
        Typeface f = st.getTypeface();
        st.setStrokeWidth(0.0f);
        st.setStyle(Paint.Style.FILL_AND_STROKE);
        st.setTypeface(font);
        g2.save();
        g2.translate(x, y);
        g2.scale(0.5f * this.size, 0.5f * this.size);
        g2.drawText(this.str, 0.0f, 0.0f, st);
        g2.restore();
        st.setStyle(s);
        st.setStrokeWidth(w);
        st.setTypeface(f);
    }

    @Override
    public int getLastFontId() {
        return 0;
    }

    static {
        try {
            KERNING = (TextAttribute)TextAttribute.class.getField("KERNING").get(TextAttribute.class);
            KERNING_ON = (Integer)TextAttribute.class.getField("KERNING_ON").get(TextAttribute.class);
            LIGATURES = (TextAttribute)TextAttribute.class.getField("LIGATURES").get(TextAttribute.class);
            LIGATURES_ON = (Integer)TextAttribute.class.getField("LIGATURES_ON").get(TextAttribute.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

