/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.MulticolumnAtom;
import org.scilab.forge.jlatexmath.core.SpaceAtom;
import org.scilab.forge.jlatexmath.core.StrutBox;
import org.scilab.forge.jlatexmath.core.SymbolAtom;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;

public class HdotsforAtom
extends MulticolumnAtom {
    private static final Atom ldotp = SymbolAtom.get("ldotp");
    private static final Atom thin = new SpaceAtom(1);
    private float coeff;

    public HdotsforAtom(int n, float coeff) {
        super(n, "c", ldotp);
        this.coeff = coeff;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        HorizontalBox b;
        StrutBox sp = new StrutBox(this.coeff * thin.createBox(env).getWidth(), 0.0f, 0.0f, 0.0f);
        HorizontalBox db = new HorizontalBox(sp);
        db.add(ldotp.createBox(env));
        db.add(sp);
        if (this.w != 0.0f) {
            float dw = db.getWidth();
            b = new HorizontalBox(db);
            while (b.getWidth() < this.w) {
                ((Box)b).add(db);
            }
            b = new HorizontalBox(b, this.w, 2);
        } else {
            b = db;
        }
        b.type = 12;
        return b;
    }
}

