/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.Char;
import org.scilab.forge.jlatexmath.core.CharBox;
import org.scilab.forge.jlatexmath.core.Extension;
import org.scilab.forge.jlatexmath.core.Metrics;
import org.scilab.forge.jlatexmath.core.SymbolAtom;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFont;
import org.scilab.forge.jlatexmath.core.VerticalBox;

public class DelimiterFactory {
    public static Box create(SymbolAtom symbol, TeXEnvironment env, int size) {
        int i;
        if (size > 4) {
            return symbol.createBox(env);
        }
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Char c = tf.getChar(symbol.getName(), style);
        for (i = 1; i <= size && tf.hasNextLarger(c); ++i) {
            c = tf.getNextLarger(c, style);
        }
        if (i <= size && !tf.hasNextLarger(c)) {
            CharBox A = new CharBox(tf.getChar('A', "mathnormal", style));
            Box b = DelimiterFactory.create(symbol.getName(), env, (float)size * (A.getHeight() + A.getDepth()));
            return b;
        }
        return new CharBox(c);
    }

    public static Box create(String symbol, TeXEnvironment env, float minHeight) {
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Char c = tf.getChar(symbol, style);
        Metrics m = c.getMetrics();
        float total = m.getHeight() + m.getDepth();
        while (total < minHeight && tf.hasNextLarger(c)) {
            c = tf.getNextLarger(c, style);
            m = c.getMetrics();
            total = m.getHeight() + m.getDepth();
        }
        if (total >= minHeight) {
            return new CharBox(c);
        }
        if (tf.isExtensionChar(c)) {
            boolean middle;
            VerticalBox vBox = new VerticalBox();
            Extension ext = tf.getExtension(c, style);
            if (ext.hasTop()) {
                c = ext.getTop();
                vBox.add(new CharBox(c));
            }
            if (middle = ext.hasMiddle()) {
                c = ext.getMiddle();
                vBox.add(new CharBox(c));
            }
            if (ext.hasBottom()) {
                c = ext.getBottom();
                vBox.add(new CharBox(c));
            }
            c = ext.getRepeat();
            CharBox rep = new CharBox(c);
            while (vBox.getHeight() + vBox.getDepth() <= minHeight) {
                if (ext.hasTop() && ext.hasBottom()) {
                    vBox.add(1, rep);
                    if (!middle) continue;
                    vBox.add(vBox.getSize() - 1, rep);
                    continue;
                }
                if (ext.hasBottom()) {
                    vBox.add(0, rep);
                    continue;
                }
                vBox.add(rep);
            }
            return vBox;
        }
        return new CharBox(c);
    }
}

