/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.util.LinkedList;
import org.scilab.forge.jlatexmath.core.AjLatexMath;

public abstract class Box {
    public static boolean DEBUG = false;
    protected Integer foreground = -16777216;
    protected Integer background = -1;
    private Integer prevColor;
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected float depth = 0.0f;
    protected float shift = 0.0f;
    protected int type = -1;
    protected LinkedList<Box> children = new LinkedList();
    protected Box parent;
    protected Box elderParent;
    protected Integer markForDEBUG = -65536;

    public void add(Box b) {
        this.children.add(b);
        b.parent = this;
        b.elderParent = this.elderParent;
    }

    public void add(int pos, Box b) {
        this.children.add(pos, b);
        b.parent = this;
        b.elderParent = this.elderParent;
    }

    protected Box() {
        this(null, null);
    }

    protected Box(Integer fg, Integer bg) {
        this.foreground = fg;
        this.background = bg;
    }

    public void setParent(Box parent) {
        this.parent = parent;
    }

    public Box getParent() {
        return this.parent;
    }

    public void setElderParent(Box elderParent) {
        this.elderParent = elderParent;
    }

    public Box getElderParent() {
        return this.elderParent;
    }

    public float getWidth() {
        return this.width;
    }

    public void negWidth() {
        this.width = -this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getShift() {
        return this.shift;
    }

    public void setWidth(float w) {
        this.width = w;
    }

    public void setDepth(float d) {
        this.depth = d;
    }

    public void setHeight(float h) {
        this.height = h;
    }

    public void setShift(float s) {
        this.shift = s;
    }

    public abstract void draw(Canvas var1, float var2, float var3);

    public abstract int getLastFontId();

    protected void startDraw(Canvas g2, float x, float y) {
        this.prevColor = AjLatexMath.getPaint().getColor();
        if (this.background != null) {
            AjLatexMath.getPaint().setColor(this.background.intValue());
        }
        if (this.foreground == null) {
            AjLatexMath.getPaint().setColor(this.prevColor.intValue());
        } else {
            AjLatexMath.getPaint().setColor(this.foreground.intValue());
        }
        this.drawDebug(g2, x, y);
    }

    protected void drawDebug(Canvas g2, float x, float y, boolean showDepth) {
        if (DEBUG) {
            Paint st = AjLatexMath.getPaint();
            int c = st.getColor();
            st.setColor(this.markForDEBUG.intValue());
            st.setStyle(Paint.Style.FILL_AND_STROKE);
            if (this.markForDEBUG != null) {
                g2.drawRect(x, y - this.height, this.width, this.height + this.depth, st);
            }
            if (this.width < 0.0f) {
                x += this.width;
                this.width = -this.width;
            }
            g2.drawRect(x, y - this.height, this.width, this.height + this.depth, st);
            if (showDepth) {
                st.setColor(-65536);
                if (this.depth > 0.0f) {
                    g2.drawRect(x, y, this.width, this.depth, st);
                } else if (this.depth < 0.0f) {
                    g2.drawRect(x, y + this.depth, this.width, -this.depth, st);
                }
            }
            st.setColor(c);
        }
    }

    protected void drawDebug(Canvas g2, float x, float y) {
        if (DEBUG) {
            this.drawDebug(g2, x, y, true);
        }
    }

    protected void endDraw(Canvas g2) {
        AjLatexMath.getPaint().setColor(this.prevColor.intValue());
    }
}

