/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.DelimiterFactory;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.SymbolAtom;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;

public class BigDelimiterAtom
extends Atom {
    public SymbolAtom delim;
    private int size;

    public BigDelimiterAtom(SymbolAtom delim, int size) {
        this.delim = delim;
        this.size = size;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box b = DelimiterFactory.create(this.delim, env, this.size);
        HorizontalBox hbox = new HorizontalBox();
        float h = b.getHeight();
        float total = h + b.getDepth();
        float axis = env.getTeXFont().getAxisHeight(env.getStyle());
        b.setShift(-total / 2.0f + h - axis);
        hbox.add(b);
        return hbox;
    }
}

