/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.core;

import org.scilab.forge.jlatexmath.core.Atom;
import org.scilab.forge.jlatexmath.core.Box;
import org.scilab.forge.jlatexmath.core.Char;
import org.scilab.forge.jlatexmath.core.CharBox;
import org.scilab.forge.jlatexmath.core.CharSymbol;
import org.scilab.forge.jlatexmath.core.HorizontalBox;
import org.scilab.forge.jlatexmath.core.InvalidSymbolTypeException;
import org.scilab.forge.jlatexmath.core.InvalidTeXFormulaException;
import org.scilab.forge.jlatexmath.core.SpaceAtom;
import org.scilab.forge.jlatexmath.core.StrutBox;
import org.scilab.forge.jlatexmath.core.SymbolAtom;
import org.scilab.forge.jlatexmath.core.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.core.TeXEnvironment;
import org.scilab.forge.jlatexmath.core.TeXFont;
import org.scilab.forge.jlatexmath.core.TeXFormula;
import org.scilab.forge.jlatexmath.core.VerticalBox;

public class AccentedAtom
extends Atom {
    private final SymbolAtom accent;
    private boolean acc = false;
    private boolean changeSize = true;
    protected Atom base = null;
    protected Atom underbase = null;

    public AccentedAtom(Atom base, Atom accent) throws InvalidSymbolTypeException {
        this.base = base;
        this.underbase = base instanceof AccentedAtom ? ((AccentedAtom)base).underbase : base;
        if (!(accent instanceof SymbolAtom)) {
            throw new InvalidSymbolTypeException("Invalid accent");
        }
        this.accent = (SymbolAtom)accent;
        this.acc = true;
    }

    public AccentedAtom(Atom base, Atom accent, boolean changeSize) throws InvalidSymbolTypeException {
        this(base, accent);
        this.changeSize = changeSize;
    }

    public AccentedAtom(Atom base, String accentName) throws InvalidSymbolTypeException, SymbolNotFoundException {
        this.accent = SymbolAtom.get(accentName);
        if (this.accent.type == 10) {
            this.base = base;
            this.underbase = base instanceof AccentedAtom ? ((AccentedAtom)base).underbase : base;
        } else {
            throw new InvalidSymbolTypeException("The symbol with the name '" + accentName + "' is not defined as an accent (" + "type" + "='acc') in '" + "TeXSymbols.xml" + "'!");
        }
    }

    public AccentedAtom(Atom base, TeXFormula acc) throws InvalidTeXFormulaException, InvalidSymbolTypeException {
        if (acc == null) {
            throw new InvalidTeXFormulaException("The accent TeXFormula can't be null!");
        }
        Atom root = acc.root;
        if (root instanceof SymbolAtom) {
            this.accent = (SymbolAtom)root;
            if (this.accent.type != 10) {
                throw new InvalidSymbolTypeException("The accent TeXFormula represents a single symbol with the name '" + this.accent.getName() + "', but this symbol is not defined as an accent (" + "type" + "='acc') in '" + "TeXSymbols.xml" + "'!");
            }
        } else {
            throw new InvalidTeXFormulaException("The accent TeXFormula does not represent a single symbol!");
        }
        this.base = base;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        Box y;
        Char larger;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Box b = this.base == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.base.createBox(env.crampStyle());
        float u = b.getWidth();
        float s = 0.0f;
        if (this.underbase instanceof CharSymbol) {
            s = tf.getSkew(((CharSymbol)this.underbase).getCharFont(tf), style);
        }
        Char ch = tf.getChar(this.accent.getName(), style);
        while (tf.hasNextLarger(ch) && (larger = tf.getNextLarger(ch, style)).getWidth() <= u) {
            ch = larger;
        }
        float ec = -SpaceAtom.getFactor(5, env);
        float delta = this.acc ? ec : Math.min(b.getHeight(), tf.getXHeight(style, ch.getFontCode()));
        VerticalBox vBox = new VerticalBox();
        float italic = ch.getItalic();
        Box cb = new CharBox(ch);
        if (this.acc) {
            cb = this.accent.createBox(this.changeSize ? env.subStyle() : env);
        }
        if (Math.abs(italic) > 1.0E-7f) {
            y = new HorizontalBox(new StrutBox(-italic, 0.0f, 0.0f, 0.0f));
            y.add(cb);
        } else {
            y = cb;
        }
        float diff = (u - y.getWidth()) / 2.0f;
        y.setShift(s + (diff > 0.0f ? diff : 0.0f));
        if (diff < 0.0f) {
            b = new HorizontalBox(b, y.getWidth(), 2);
        }
        vBox.add(y);
        vBox.add(new StrutBox(0.0f, this.changeSize ? -delta : -b.getHeight(), 0.0f, 0.0f));
        vBox.add(b);
        float total = vBox.getHeight() + vBox.getDepth();
        float d = b.getDepth();
        vBox.setDepth(d);
        vBox.setHeight(total - d);
        if (diff < 0.0f) {
            HorizontalBox hb = new HorizontalBox(new StrutBox(diff, 0.0f, 0.0f, 0.0f));
            hb.add(vBox);
            hb.setWidth(u);
            return hb;
        }
        return vBox;
    }
}

