/*
 * Decompiled with CFR 0.152.
 */
package com.daquexian.flexiblerichtextview;

import android.util.Log;
import com.daquexian.flexiblerichtextview.Attachment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Tokenizer {
    private static List<String> colorStartLabels = new ArrayList<String>();
    private static List<String> colorEndLabels = new ArrayList<String>();
    private static List<String> urlStartLabels = new ArrayList<String>();
    private static List<String> urlEndLabels = new ArrayList<String>();
    private static List<String> curtainStartLabels = new ArrayList<String>();
    private static List<String> curtainEndLabels = new ArrayList<String>();
    private static List<String> underlineStartLabels = new ArrayList<String>();
    private static List<String> underlineEndLabels = new ArrayList<String>();
    private static List<String> boldStartLabels = new ArrayList<String>();
    private static List<String> boldEndLabels = new ArrayList<String>();
    private static List<String> italicStartLabels = new ArrayList<String>();
    private static List<String> italicEndLabels = new ArrayList<String>();
    private static List<String> deleteStartLabels = new ArrayList<String>();
    private static List<String> deleteEndLabels = new ArrayList<String>();
    private static List<String> centerStartLabels = new ArrayList<String>();
    private static List<String> centerEndLabels = new ArrayList<String>();
    private static List<String> titleStartLabels = new ArrayList<String>();
    private static List<String> titleEndLabels = new ArrayList<String>();
    private static List<String> attachmentLabels = new ArrayList<String>();
    private static List<String> imageLabels = new ArrayList<String>();
    private static List<String> codeStartLabels = new ArrayList<String>();
    private static List<String> codeEndLabels = new ArrayList<String>();
    private static List<String> quoteStartLabels = new ArrayList<String>();
    private static List<String> quoteEndLabels = new ArrayList<String>();
    private static List<ImgPos> imgPosList = new ArrayList<ImgPos>();
    private static List<QuotePos> quotePosList = new ArrayList<QuotePos>();
    private static final String TAG = "Tokenizer";
    private static List<String> iconStrs = new ArrayList<String>();
    private static List<Integer> icons = new ArrayList<Integer>();
    private static final Pattern FORMULA_REG1;
    private static final Pattern FORMULA_REG2;
    private static final Pattern FORMULA_REG3;
    private static final Pattern FORMULA_REG4;
    private static final Pattern[] PATTERNS;
    private static final Pattern IMG_REG;
    private static final Pattern TABLE_REG;

    public static int setUrlStartLabel(String ... labels) {
        int ret = labels.length;
        urlStartLabels = new ArrayList<String>();
        for (String label : labels) {
            if (!label.contains("\\s")) continue;
            urlStartLabels.add(Tokenizer.formatLabel(label).replaceAll("\\\\s", "(.+?)"));
            --ret;
        }
        return ret;
    }

    public static int setColorStartLabel(String ... labels) {
        int ret = labels.length;
        colorStartLabels = new ArrayList<String>();
        for (String label : labels) {
            if (!label.contains("\\s")) continue;
            colorStartLabels.add(Tokenizer.formatLabel(label).replaceAll("\\\\s", "(.+?)"));
            --ret;
        }
        return ret;
    }

    public static int setCurtainStartLabels(String ... labels) {
        int ret = labels.length;
        curtainStartLabels = new ArrayList<String>();
        for (String label : labels) {
            curtainStartLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setBoldStartLabels(String ... labels) {
        int ret = labels.length;
        boldStartLabels = new ArrayList<String>();
        for (String label : labels) {
            boldStartLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setCodeStartLabels(String ... labels) {
        int ret = labels.length;
        codeStartLabels = new ArrayList<String>();
        for (String label : labels) {
            codeStartLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setQuoteStartLabels(String ... labels) {
        int ret = labels.length;
        quoteStartLabels = new ArrayList<String>();
        quotePosList = new ArrayList<QuotePos>();
        for (String label : labels) {
            byte tmp = 1;
            byte postIdPos = -1;
            byte memberPos = -1;
            for (int i = 0; i < label.length() - 1; ++i) {
                if (label.substring(i).startsWith("\\m")) {
                    byte by = tmp;
                    tmp = (byte)(tmp + 1);
                    memberPos = by;
                    continue;
                }
                if (!label.substring(i).startsWith("\\p")) continue;
                byte by = tmp;
                tmp = (byte)(tmp + 1);
                postIdPos = by;
            }
            quoteStartLabels.add(Tokenizer.formatLabel(label).replaceAll("\\\\m", "(.+?)").replaceAll("\\\\p", "(.+?)"));
            quotePosList.add(new QuotePos(postIdPos, memberPos));
            --ret;
        }
        return ret;
    }

    public static int setItalicStartLabels(String ... labels) {
        int ret = labels.length;
        italicStartLabels = new ArrayList<String>();
        for (String label : labels) {
            italicStartLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setCenterStartLabels(String ... labels) {
        int ret = labels.length;
        centerStartLabels = new ArrayList<String>();
        for (String label : labels) {
            centerStartLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setDeleteStartLabels(String ... labels) {
        int ret = labels.length;
        deleteStartLabels = new ArrayList<String>();
        for (String label : labels) {
            deleteStartLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setTitleStartLabels(String ... labels) {
        int ret = labels.length;
        titleStartLabels = new ArrayList<String>();
        for (String label : labels) {
            titleStartLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setTitleEndLabels(String ... labels) {
        int ret = labels.length;
        titleEndLabels = new ArrayList<String>();
        for (String label : labels) {
            titleEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setColorEndLabels(String ... labels) {
        int ret = labels.length;
        colorEndLabels = new ArrayList<String>();
        for (String label : labels) {
            colorEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setCurtainEndLabels(String ... labels) {
        int ret = labels.length;
        curtainEndLabels = new ArrayList<String>();
        for (String label : labels) {
            curtainEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setCodeEndLabels(String ... labels) {
        int ret = labels.length;
        codeEndLabels = new ArrayList<String>();
        for (String label : labels) {
            codeEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setQuoteEndLabels(String ... labels) {
        int ret = labels.length;
        quoteEndLabels = new ArrayList<String>();
        for (String label : labels) {
            quoteEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setCenterEndLabels(String ... labels) {
        int ret = labels.length;
        centerEndLabels = new ArrayList<String>();
        for (String label : labels) {
            centerEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setBoldEndLabels(String ... labels) {
        int ret = labels.length;
        boldEndLabels = new ArrayList<String>();
        for (String label : labels) {
            boldEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setItalicEndLabels(String ... labels) {
        int ret = labels.length;
        italicEndLabels = new ArrayList<String>();
        for (String label : labels) {
            italicEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setUrlEndLabels(String ... labels) {
        int ret = labels.length;
        urlEndLabels = new ArrayList<String>();
        for (String label : labels) {
            urlEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setDeleteEndLabels(String ... labels) {
        int ret = labels.length;
        deleteEndLabels = new ArrayList<String>();
        for (String label : labels) {
            deleteEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setAttachmentLabels(String ... labels) {
        int ret = labels.length;
        attachmentLabels = new ArrayList<String>();
        for (String label : labels) {
            if (!label.contains("\\s")) continue;
            attachmentLabels.add(Tokenizer.formatLabel(label).replaceAll("\\\\s", "(.+?)"));
            --ret;
        }
        return ret;
    }

    public static int setUnderlineStartLabels(String ... labels) {
        int ret = labels.length;
        underlineStartLabels = new ArrayList<String>();
        for (String label : labels) {
            underlineStartLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setUnderlineEndLabels(String ... labels) {
        int ret = labels.length;
        underlineEndLabels = new ArrayList<String>();
        for (String label : labels) {
            underlineEndLabels.add(Tokenizer.formatLabel(label));
            --ret;
        }
        return ret;
    }

    public static int setImageLabels(String ... labels) {
        int ret = labels.length;
        imageLabels = new ArrayList<String>();
        imgPosList = new ArrayList<ImgPos>();
        for (String label : labels) {
            boolean hasUrl = false;
            byte tmp = 1;
            byte widthPos = -1;
            byte heightPos = -1;
            byte urlPos = -1;
            byte sizePos = -1;
            for (int j = 0; j < label.length() - 1; ++j) {
                if (label.substring(j).startsWith("\\w")) {
                    byte by = tmp;
                    tmp = (byte)(tmp + 1);
                    widthPos = by;
                    continue;
                }
                if (label.substring(j).startsWith("\\h")) {
                    byte by = tmp;
                    tmp = (byte)(tmp + 1);
                    heightPos = by;
                    continue;
                }
                if (label.substring(j).startsWith("\\s")) {
                    byte by = tmp;
                    tmp = (byte)(tmp + 1);
                    sizePos = by;
                    continue;
                }
                if (!label.substring(j).startsWith("\\u")) continue;
                byte by = tmp;
                tmp = (byte)(tmp + 1);
                urlPos = by;
                hasUrl = true;
            }
            if (!hasUrl) continue;
            imageLabels.add(Tokenizer.formatLabel(label).replaceAll("\\\\w", "(\\\\d+?)").replaceAll("\\\\h", "(\\\\d+?)").replaceAll("\\\\s", "(\\\\d+?)").replaceAll("\\\\u", "(.+?)"));
            if (sizePos == -1) {
                imgPosList.add(new ImgPos(widthPos, heightPos, urlPos));
            } else {
                imgPosList.add(new ImgPos(sizePos, urlPos));
            }
            --ret;
        }
        return ret;
    }

    public static void setIconStrs(String ... iconStrs) {
        Tokenizer.iconStrs = new ArrayList<String>();
        Collections.addAll(Tokenizer.iconStrs, iconStrs);
    }

    public static void setIcons(Integer ... icons) {
        Tokenizer.icons = new ArrayList<Integer>();
        Collections.addAll(Tokenizer.icons, icons);
    }

    private static String formatLabel(String label) {
        return "(?i)" + label.replaceAll("\\[", "\\\\[").replaceAll("\\(", "\\\\(");
    }

    private static void initLabels() {
        Tokenizer.setUrlStartLabel("[url=\\s]");
        Tokenizer.setUrlEndLabels("[/url]");
        Tokenizer.setAttachmentLabels("[attachment:\\s]");
        Tokenizer.setBoldStartLabels("[b]");
        Tokenizer.setBoldEndLabels("[/b]");
        Tokenizer.setItalicStartLabels("[i]");
        Tokenizer.setItalicEndLabels("[/i]");
        Tokenizer.setCurtainStartLabels("[curtain]");
        Tokenizer.setCurtainEndLabels("[/curtain]");
        Tokenizer.setCenterStartLabels("[center]");
        Tokenizer.setCenterEndLabels("[/center]");
        Tokenizer.setCodeStartLabels("[code]");
        Tokenizer.setCodeEndLabels("[/code]");
        Tokenizer.setTitleStartLabels("[h]");
        Tokenizer.setTitleEndLabels("[/h]");
        Tokenizer.setColorStartLabel("[c=\\s]", "[color=\\s]");
        Tokenizer.setColorEndLabels("[/c]", "[/color]");
        Tokenizer.setQuoteStartLabels("[quote]", "[quote=\\p:@\\m]");
        Tokenizer.setQuoteEndLabels("[/quote]");
        Tokenizer.setImageLabels("[img]\\u[/img]", "[img=\\s]\\u[/img]");
        Tokenizer.setDeleteStartLabels("[s]");
        Tokenizer.setDeleteEndLabels("[/s]");
        Tokenizer.setUnderlineStartLabels("[u]");
        Tokenizer.setUnderlineEndLabels("[/u]");
    }

    public static List<TOKEN> tokenizer(CharSequence text, List<Attachment> attachmentList) {
        int start;
        int i;
        int i2;
        Matcher matcher;
        Pattern pattern;
        ArrayList<TOKEN> tokenList = new ArrayList<TOKEN>();
        for (String colorStartLabel : colorStartLabels) {
            pattern = Pattern.compile(colorStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new COLOR_START(matcher.start(), matcher.group(), matcher.group(1)));
            }
        }
        for (String urlStartLabel : urlStartLabels) {
            pattern = Pattern.compile(urlStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                String url = matcher.group(1).toLowerCase();
                if (!url.startsWith("http://") && !url.startsWith("https://")) {
                    url = "http://" + url;
                }
                tokenList.add(new URL_START(matcher.start(), url, matcher.group()));
            }
        }
        for (String urlEndLabel : urlEndLabels) {
            pattern = Pattern.compile(urlEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new URL_END(matcher.start(), matcher.group()));
            }
        }
        for (String centerStartLabel : centerStartLabels) {
            pattern = Pattern.compile(centerStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new CENTER_START(matcher.start(), matcher.group()));
            }
        }
        for (String centerEndLabel : centerEndLabels) {
            pattern = Pattern.compile(centerEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new CENTER_END(matcher.start(), matcher.group()));
            }
        }
        for (String curtainStartLabel : curtainStartLabels) {
            pattern = Pattern.compile(curtainStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new CURTAIN_START(matcher.start(), matcher.group()));
            }
        }
        for (String curtainEndLabel : curtainEndLabels) {
            pattern = Pattern.compile(curtainEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new CURTAIN_END(matcher.start(), matcher.group()));
            }
        }
        for (String attachmentLabel : attachmentLabels) {
            pattern = Pattern.compile(attachmentLabel);
            matcher = pattern.matcher(text);
            block15: while (matcher.find()) {
                String id = matcher.group(1);
                if (attachmentList == null) continue;
                for (Attachment attachment : attachmentList) {
                    if (!attachment.getAttachmentId().equals(id)) continue;
                    tokenList.add(new ATTACHMENT(matcher.start(), attachment, matcher.group()));
                    continue block15;
                }
            }
        }
        for (String colorEndLabel : colorEndLabels) {
            pattern = Pattern.compile(colorEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new COLOR_END(matcher.start(), matcher.group()));
            }
        }
        for (String italicStartLabel : italicStartLabels) {
            pattern = Pattern.compile(italicStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new ITALIC_START(matcher.start(), matcher.group()));
            }
        }
        for (String italicEndLabel : italicEndLabels) {
            pattern = Pattern.compile(italicEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new ITALIC_END(matcher.start(), matcher.group()));
            }
        }
        for (String boldStartLabel : boldStartLabels) {
            pattern = Pattern.compile(boldStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new BOLD_START(matcher.start(), matcher.group()));
            }
        }
        for (String boldEndLabel : boldEndLabels) {
            pattern = Pattern.compile(boldEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new BOLD_END(matcher.start(), matcher.group()));
            }
        }
        for (String deleteStartLabel : deleteStartLabels) {
            pattern = Pattern.compile(deleteStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new DELETE_START(matcher.start(), matcher.group()));
            }
        }
        for (String deleteEndLabel : deleteEndLabels) {
            pattern = Pattern.compile(deleteEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new DELETE_END(matcher.start(), matcher.group()));
            }
        }
        for (String underlineStartLabel : underlineStartLabels) {
            pattern = Pattern.compile(underlineStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new UNDERLINE_START(matcher.start(), matcher.group()));
            }
        }
        for (String underlineEndLabel : underlineEndLabels) {
            pattern = Pattern.compile(underlineEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new UNDERLINE_END(matcher.start(), matcher.group()));
            }
        }
        for (String titleStartLabel : titleStartLabels) {
            pattern = Pattern.compile(titleStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new TITLE_START(matcher.start(), matcher.group()));
            }
        }
        for (String titleEndLabel : titleEndLabels) {
            pattern = Pattern.compile(titleEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new TITLE_END(matcher.start(), matcher.group()));
            }
        }
        for (String codeStartLabel : codeStartLabels) {
            pattern = Pattern.compile(codeStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new CODE_START(matcher.start(), matcher.group()));
            }
        }
        for (String codeEndLabel : codeEndLabels) {
            pattern = Pattern.compile(codeEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new CODE_END(matcher.start(), matcher.group()));
            }
        }
        for (int i3 = 0; i3 < quoteStartLabels.size(); ++i3) {
            String quoteStartLabel = quoteStartLabels.get(i3);
            QuotePos quotePos = quotePosList.get(i3);
            pattern = Pattern.compile(quoteStartLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                if (quotePos.postIdPos == -1 && quotePos.memberPos == -1) {
                    tokenList.add(new QUOTE_START(matcher.start(), matcher.group(), "", ""));
                    continue;
                }
                if (quotePos.postIdPos == -1) {
                    tokenList.add(new QUOTE_START(matcher.start(), matcher.group(), matcher.group(1), ""));
                    continue;
                }
                if (quotePos.memberPos == -1) {
                    tokenList.add(new QUOTE_START(matcher.start(), matcher.group(), "", matcher.group(1)));
                    continue;
                }
                tokenList.add(new QUOTE_START(matcher.start(), matcher.group(), matcher.group(quotePos.memberPos), matcher.group(quotePos.postIdPos)));
            }
        }
        for (String quoteEndLabel : quoteEndLabels) {
            pattern = Pattern.compile(quoteEndLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                tokenList.add(new QUOTE_END(matcher.start(), matcher.group()));
            }
        }
        String str = text.toString();
        for (i2 = 0; i2 < iconStrs.size(); ++i2) {
            int from = 0;
            String iconStr = iconStrs.get(i2);
            while ((from = str.indexOf(iconStr, from)) >= 0) {
                if (iconStr.equals("/^^")) {
                    Log.d((String)TAG, (String)("parse: " + str.trim().length() + ", " + iconStr.length() + ", " + (from + iconStr.length()) + ", " + str.length()));
                }
                if (str.trim().length() == iconStr.length() || (from == 0 || ' ' == str.charAt(from - 1)) && (from + iconStr.length() == str.length() || ' ' == str.charAt(from + iconStr.length()) || '\n' == str.charAt(from + iconStr.length()))) {
                    tokenList.add(new ICON(from, iconStr, icons.get(i2)));
                }
                from += iconStr.length();
            }
        }
        for (i2 = 0; i2 < imageLabels.size(); ++i2) {
            String imageLabel = imageLabels.get(i2);
            ImgPos imgPos = imgPosList.get(i2);
            pattern = Pattern.compile(imageLabel);
            matcher = pattern.matcher(text);
            while (matcher.find()) {
                if (imgPos.heightPos == -1 && imgPos.widthPos == -1) {
                    tokenList.add(new IMAGE(matcher.start(), matcher.group(1), matcher.group()));
                    continue;
                }
                if (imgPos.heightPos == -1) {
                    tokenList.add(new IMAGE(matcher.start(), matcher.group(imgPos.urlPos), matcher.group(), Integer.valueOf(matcher.group(imgPos.widthPos)), -1));
                    continue;
                }
                if (imgPos.widthPos == -1) {
                    tokenList.add(new IMAGE(matcher.start(), matcher.group(imgPos.urlPos), matcher.group(), -1, Integer.valueOf(matcher.group(imgPos.heightPos))));
                    continue;
                }
                tokenList.add(new IMAGE(matcher.start(), matcher.group(imgPos.urlPos), matcher.group(), Integer.valueOf(matcher.group(imgPos.widthPos)), Integer.valueOf(matcher.group(imgPos.heightPos))));
            }
        }
        pattern = TABLE_REG;
        matcher = pattern.matcher(text);
        while (matcher.find()) {
            tokenList.add(new TABLE(matcher.start(), matcher.group()));
        }
        int[] indexInRegex = new int[]{1, 1, 1, 0, 1};
        Matcher[] matchers = new Matcher[PATTERNS.length];
        for (i = 0; i < PATTERNS.length; ++i) {
            matchers[i] = PATTERNS[i].matcher(text);
        }
        for (i = 0; i < matchers.length; ++i) {
            matcher = matchers[i];
            int index = indexInRegex[i];
            while (matcher.find()) {
                start = matcher.start();
                String content = matcher.group(index);
                String value = matcher.group();
                int contentStart = matcher.start(index);
                tokenList.add(new FORMULA(start, content, contentStart - start, value));
            }
        }
        Collections.sort(tokenList);
        block55: for (i = 0; i < tokenList.size(); ++i) {
            TOKEN token = (TOKEN)tokenList.get(i);
            if (!(token instanceof TABLE)) continue;
            for (int j = 0; j < tokenList.size(); ++j) {
                TOKEN token1 = (TOKEN)tokenList.get(j);
                if (token1.position >= token.position + token.length) continue block55;
                if (token1.position <= token.position) continue;
                tokenList.remove(j);
                --j;
            }
        }
        tokenList.add(new END(text.length()));
        Tokenizer.removeOverlappingTokens(tokenList);
        start = 0;
        for (i = 0; i < tokenList.size(); ++i) {
            TOKEN token = (TOKEN)tokenList.get(i);
            if (token.position > start) {
                tokenList.add(i, new PLAIN(start, text.subSequence(start, token.position)));
                ++i;
            }
            start = token.position + token.length;
        }
        return tokenList;
    }

    private static void removeOverlappingTokens(List<TOKEN> tokenList) {
        for (int i = tokenList.size() - 1; i >= 1; --i) {
            TOKEN thisToken = tokenList.get(i);
            TOKEN prevToken = tokenList.get(i - 1);
            if (thisToken.position >= prevToken.position + prevToken.length) continue;
            tokenList.remove(thisToken);
        }
    }

    static {
        Tokenizer.initLabels();
        FORMULA_REG1 = Pattern.compile("(?i)\\$\\$?((.|\\n)+?)\\$\\$?");
        FORMULA_REG2 = Pattern.compile("(?i)\\\\[(\\[]((.|\\n)*?)\\\\[\\])]");
        FORMULA_REG3 = Pattern.compile("(?i)\\[tex]((.|\\n)*?)\\[/tex]");
        FORMULA_REG4 = Pattern.compile("(?i)\\\\begin\\{.*?\\}(.|\\n)*?\\\\end\\{.*?\\}");
        PATTERNS = new Pattern[]{FORMULA_REG1, FORMULA_REG2, FORMULA_REG3, FORMULA_REG4};
        IMG_REG = Pattern.compile("(?i)\\[img(=\\d+)?](.*?)\\[/img]");
        TABLE_REG = Pattern.compile("(?:\\n|^)( *\\|.+\\| *\\n)??( *\\|(?: *:?----*:? *\\|)+ *\\n)((?: *\\|.+\\| *(?:\\n|$))+)");
    }

    private static class QuotePos {
        byte postIdPos = (byte)-1;
        byte memberPos = (byte)-1;

        public QuotePos(byte postIdPos, byte memberPos) {
            this.postIdPos = postIdPos;
            this.memberPos = memberPos;
        }
    }

    private static class ImgPos {
        byte widthPos = (byte)-1;
        byte heightPos = (byte)-1;
        byte urlPos = (byte)-1;
        byte sizePos = (byte)-1;

        public ImgPos(byte widthPos, byte heightPos, byte urlPos) {
            this.widthPos = widthPos;
            this.heightPos = heightPos;
            this.urlPos = urlPos;
        }

        public ImgPos(byte sizePos, byte urlPos) {
            this.sizePos = sizePos;
            this.urlPos = urlPos;
        }
    }

    static class END
    extends TOKEN {
        END(int position) {
            super(position, 0, "");
        }
    }

    static class TABLE
    extends TOKEN {
        TABLE(int position, String content) {
            super(position, content.length(), content);
        }
    }

    static class IMAGE
    extends TOKEN {
        String url;
        int width;
        int height;

        IMAGE(int position, String url, String value) {
            this(position, url, value, -1);
        }

        IMAGE(int position, String url, String value, int size) {
            this(position, url, value, -1, -1);
        }

        IMAGE(int position, String url, String value, int width, int height) {
            super(position, value.length(), value);
            this.url = url;
            this.width = width;
            this.height = height;
        }
    }

    static class QUOTE_END
    extends TOKEN {
        QUOTE_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class QUOTE_START
    extends TOKEN {
        String quotedUsername;
        String postId;

        QUOTE_START(int position, String value, String quotedUsername, String postId) {
            super(position, value.length(), value);
            this.quotedUsername = quotedUsername;
            this.postId = postId;
        }
    }

    static class CODE_END
    extends TOKEN {
        CODE_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class CODE_START
    extends TOKEN {
        CODE_START(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class FORMULA
    extends TOKEN {
        String content;
        int contentStart;

        FORMULA(int position, String content, int contentStart, String value) {
            super(position, value.length(), value.replaceAll("[\n\r]", ""));
            this.content = content.replaceAll("[\n\r]", "");
            this.contentStart = contentStart;
        }
    }

    static class ICON
    extends TOKEN {
        int iconId;

        ICON(int position, String iconStr, int iconId) {
            super(position, iconStr.length(), iconStr);
            this.iconId = iconId;
        }
    }

    static class ATTACHMENT
    extends TOKEN {
        Attachment attachment;

        ATTACHMENT(int position, Attachment attachment, String value) {
            super(position, value.length(), value);
            this.attachment = attachment;
        }
    }

    static class TITLE_END
    extends TOKEN {
        TITLE_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class TITLE_START
    extends TOKEN {
        TITLE_START(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class CENTER_END
    extends TOKEN {
        CENTER_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class CENTER_START
    extends TOKEN {
        CENTER_START(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class DELETE_END
    extends TOKEN {
        DELETE_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class DELETE_START
    extends TOKEN {
        DELETE_START(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class UNDERLINE_END
    extends TOKEN {
        UNDERLINE_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class UNDERLINE_START
    extends TOKEN {
        UNDERLINE_START(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class ITALIC_END
    extends TOKEN {
        ITALIC_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class ITALIC_START
    extends TOKEN {
        ITALIC_START(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class BOLD_END
    extends TOKEN {
        BOLD_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class BOLD_START
    extends TOKEN {
        BOLD_START(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class CURTAIN_END
    extends TOKEN {
        CURTAIN_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class CURTAIN_START
    extends TOKEN {
        CURTAIN_START(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class URL_END
    extends TOKEN {
        URL_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class URL_START
    extends TOKEN {
        String url;

        URL_START(int position, String url, String value) {
            super(position, value.length(), value);
            this.url = url;
        }
    }

    static class COLOR_END
    extends TOKEN {
        COLOR_END(int position, String value) {
            super(position, value.length(), value);
        }
    }

    static class COLOR_START
    extends TOKEN {
        String color;

        COLOR_START(int position, String value, String color) {
            super(position, value.length(), value);
            this.color = color;
        }
    }

    static class PLAIN
    extends TOKEN {
        PLAIN(int position, CharSequence value) {
            super(position, value.length(), value);
        }
    }

    static abstract class TOKEN
    implements Comparable<TOKEN> {
        int position;
        int length;
        CharSequence value;

        public TOKEN(int position, int length, CharSequence value) {
            this.position = position;
            this.length = length;
            this.value = value;
        }

        public static String getString(List<TOKEN> tokens) {
            StringBuilder builder = new StringBuilder();
            for (TOKEN token : tokens) {
                builder.append(token.value);
            }
            return builder.toString();
        }

        @Override
        public int compareTo(@NotNull TOKEN token) {
            if (this.position < token.position) {
                return -1;
            }
            if (this.position == token.position) {
                if (this.length < token.length) {
                    return 1;
                }
                if (this.length > token.length) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }
    }
}

