/*
 * Decompiled with CFR 0.152.
 */
package com.daquexian.flexiblerichtextview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.widget.TextView;
import com.daquexian.flexiblerichtextview.CenteredImageSpan;
import com.daquexian.flexiblerichtextview.FlexibleRichTextView;
import com.daquexian.flexiblerichtextview.TextWithFormula;
import java.util.List;
import org.scilab.forge.jlatexmath.core.AjLatexMath;
import org.scilab.forge.jlatexmath.core.Insets;
import org.scilab.forge.jlatexmath.core.TeXFormula;
import org.scilab.forge.jlatexmath.core.TeXIcon;

public class LaTeXtView
extends TextView {
    public LaTeXtView(Context context) {
        super(context);
    }

    public void setTextWithFormula(TextWithFormula textWithFormula) {
        List<TextWithFormula.Formula> formulas = textWithFormula.getFormulas();
        TextWithFormula builder = textWithFormula;
        for (TextWithFormula.Formula formula : formulas) {
            TeXFormula teXFormula = TeXFormula.getPartialTeXFormula(formula.content);
            try {
                Bitmap bitmap = this.getBitmap(teXFormula);
                if (bitmap.getWidth() > FlexibleRichTextView.MAX_IMAGE_WIDTH) {
                    bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)FlexibleRichTextView.MAX_IMAGE_WIDTH, (int)(bitmap.getHeight() * FlexibleRichTextView.MAX_IMAGE_WIDTH / bitmap.getWidth()), (boolean)false);
                }
                builder.setSpan((Object)new CenteredImageSpan(this.getContext(), bitmap), formula.start, formula.end, 17);
            }
            catch (Exception exception) {}
        }
        this.setText((CharSequence)((Object)builder));
    }

    private Bitmap getBitmap(TeXFormula formula) {
        TeXIcon icon = new TeXFormula.TeXIconBuilder(formula).setStyle(0).setSize(this.getPaint().getTextSize() / this.getPaint().density).setWidth(9, this.getPaint().getTextSize() / this.getPaint().density, 0).setIsMaxWidth(true).setInterLineSpacing(9, AjLatexMath.getLeading(this.getPaint().getTextSize() / this.getPaint().density)).build();
        icon.setInsets(new Insets(5, 5, 5, 5));
        Bitmap image = Bitmap.createBitmap((int)icon.getIconWidth(), (int)icon.getIconHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas g2 = new Canvas(image);
        g2.drawColor(0);
        icon.paintIcon(g2, 0, 0);
        return image;
    }
}

