/*
 * Decompiled with CFR 0.152.
 */
package com.daquexian.flexiblerichtextview;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v4.content.ContextCompat;
import android.text.Layout;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.daquexian.flexiblerichtextview.Attachment;
import com.daquexian.flexiblerichtextview.FImageView;
import com.daquexian.flexiblerichtextview.LaTeXtView;
import com.daquexian.flexiblerichtextview.QuoteView;
import com.daquexian.flexiblerichtextview.R;
import com.daquexian.flexiblerichtextview.TextWithFormula;
import com.daquexian.flexiblerichtextview.Tokenizer;
import io.github.kbiakov.codeview.CodeView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlexibleRichTextView
extends LinearLayout {
    private static final String TAG = "FlexibleRichTextView";
    static final int MAX_IMAGE_WIDTH = (int)((double)Resources.getSystem().getDisplayMetrics().widthPixels * 0.8);
    private Context mContext;
    private int mConversationId;
    private List<Attachment> mAttachmentList;
    private OnViewClickListener mOnViewClickListener;
    private List<Tokenizer.TOKEN> mTokenList;
    private int mTokenIndex;
    private boolean mCenter;
    private boolean mShowRemainingAtt = true;
    private int mQuoteViewId = R.layout.default_quote_view;
    private final Class[] start = new Class[]{Tokenizer.CENTER_START.class, Tokenizer.BOLD_START.class, Tokenizer.ITALIC_START.class, Tokenizer.UNDERLINE_START.class, Tokenizer.DELETE_START.class, Tokenizer.CURTAIN_START.class, Tokenizer.TITLE_START.class, Tokenizer.COLOR_START.class, Tokenizer.URL_START.class};
    private final Class[] end = new Class[]{Tokenizer.CENTER_END.class, Tokenizer.BOLD_END.class, Tokenizer.ITALIC_END.class, Tokenizer.UNDERLINE_END.class, Tokenizer.DELETE_END.class, Tokenizer.CURTAIN_END.class, Tokenizer.TITLE_END.class, Tokenizer.COLOR_END.class, Tokenizer.URL_END.class};
    private final String CENTER_OP = "center";
    private final String BOLD_OP = "bold";
    private final String ITALIC_OP = "italic";
    private final String UNDERLINE_OP = "underline";
    private final String DELETE_OP = "delete";
    private final String CURTAIN_OP = "curtain";
    private final String TITLE_OP = "title";
    private final String COLOR_OP = "color";
    private final String URL_OP = "url";
    private final String[] operation = new String[]{"center", "bold", "italic", "underline", "delete", "curtain", "title", "color", "url"};

    public FlexibleRichTextView(Context context) {
        this(context, null, true);
    }

    public FlexibleRichTextView(Context context, OnViewClickListener onViewClickListener) {
        this(context, onViewClickListener, true);
    }

    public FlexibleRichTextView(Context context, OnViewClickListener onViewClickListener, boolean showRemainingAtt) {
        super(context);
        this.init(context, onViewClickListener, showRemainingAtt);
    }

    public FlexibleRichTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public FlexibleRichTextView(Context context, AttributeSet attributeSet, int defStyleAttr) {
        super(context, attributeSet, defStyleAttr);
        this.init(context);
    }

    public void setToken(List<Tokenizer.TOKEN> tokens, List<Attachment> attachmentList) {
        this.removeAllViews();
        this.mAttachmentList = attachmentList;
        this.mTokenList = tokens;
        for (Tokenizer.TOKEN token : tokens) {
            if (!(token instanceof Tokenizer.ATTACHMENT)) continue;
            this.mAttachmentList.remove(((Tokenizer.ATTACHMENT)token).attachment);
        }
        this.resetTokenIndex();
        List<Object> result = this.until(Tokenizer.END.class);
        if (this.mShowRemainingAtt) {
            for (Attachment att : this.mAttachmentList) {
                this.append(result, this.attachment(att));
            }
        }
        if (result == null) {
            return;
        }
        for (Object o : result) {
            if (o instanceof TextWithFormula) {
                TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                LaTeXtView textView = new LaTeXtView(this.mContext);
                textView.setTextWithFormula(textWithFormula);
                textView.setMovementMethod(LinkMovementMethod.getInstance());
                this.myAddView((View)textView);
                continue;
            }
            if (o instanceof CodeView) {
                this.myAddView((View)((CodeView)o));
                continue;
            }
            if (o instanceof ImageView) {
                this.myAddView((View)((ImageView)o));
                continue;
            }
            if (o instanceof HorizontalScrollView) {
                this.myAddView((View)((HorizontalScrollView)o));
                continue;
            }
            if (!(o instanceof QuoteView)) continue;
            this.myAddView((View)((QuoteView)((Object)o)));
        }
    }

    public void setText(String text) {
        this.setText(text, new ArrayList<Attachment>());
    }

    public void setText(String text, List<Attachment> attachmentList) {
        text = text.replaceAll("\u00ad", "");
        this.mAttachmentList = attachmentList;
        this.mTokenList = Tokenizer.tokenizer(text, this.mAttachmentList);
        this.setToken(this.mTokenList, attachmentList);
    }

    private void myAddView(View view) {
        if (view instanceof FImageView && ((FImageView)view).centered) {
            RelativeLayout rl = new RelativeLayout(this.mContext);
            RelativeLayout.LayoutParams rlLp = new RelativeLayout.LayoutParams(-2, -2);
            rlLp.addRule(13, -1);
            rl.addView(view);
            rl.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.addView((View)rl);
        } else {
            this.addView(view);
        }
    }

    private void resetTokenIndex() {
        this.mTokenIndex = 0;
    }

    private <T extends Tokenizer.TOKEN> List<Object> until(Class<T> endClass) {
        ArrayList<Object> ret = new ArrayList<Object>();
        while (!(this.thisToken() instanceof Tokenizer.END) && !endClass.isInstance(this.thisToken())) {
            int tmp;
            int i;
            boolean flag = false;
            for (Class anEnd : this.end) {
                if (!anEnd.isInstance(this.thisToken())) continue;
                this.append(ret, (Object)new TextWithFormula(this.thisToken().value));
                flag = true;
                break;
            }
            for (i = 0; i < this.start.length; ++i) {
                if (!this.start[i].isInstance(this.thisToken())) continue;
                String operand = "";
                if (this.thisToken() instanceof Tokenizer.CENTER_START) {
                    this.mCenter = true;
                } else if (this.thisToken() instanceof Tokenizer.COLOR_START) {
                    operand = ((Tokenizer.COLOR_START)this.thisToken()).color;
                } else if (this.thisToken() instanceof Tokenizer.URL_START) {
                    operand = ((Tokenizer.URL_START)this.thisToken()).url;
                }
                tmp = this.getTokenIndex();
                this.next();
                List<Object> shown = this.until(this.end[i]);
                this.mCenter = false;
                if (shown != null) {
                    this.concat(ret, this.operate(shown, this.operation[i], operand));
                } else {
                    this.setTokenIndex(tmp);
                    this.append(ret, (Object)new TextWithFormula(this.thisToken().value));
                }
                flag = true;
            }
            if (!flag) {
                if (this.thisToken() instanceof Tokenizer.PLAIN) {
                    this.append(ret, (Object)new TextWithFormula(this.thisToken().value));
                } else if (this.thisToken() instanceof Tokenizer.ICON) {
                    Tokenizer.ICON thisToken = (Tokenizer.ICON)this.thisToken();
                    TextWithFormula textWithFormula = new TextWithFormula(thisToken.value);
                    textWithFormula.setSpan(new ImageSpan(this.mContext, thisToken.iconId), 0, thisToken.value.length(), 17);
                    this.append(ret, (Object)textWithFormula);
                } else if (this.thisToken() instanceof Tokenizer.FORMULA) {
                    Tokenizer.FORMULA thisToken = (Tokenizer.FORMULA)this.thisToken();
                    TextWithFormula textWithFormula = new TextWithFormula(this.thisToken().value);
                    textWithFormula.addFormula(0, thisToken.value.length(), thisToken.content, thisToken.contentStart, thisToken.contentStart + thisToken.content.length());
                    this.append(ret, (Object)textWithFormula);
                } else if (this.thisToken() instanceof Tokenizer.CODE_START) {
                    CodeView codeView;
                    tmp = this.getTokenIndex();
                    i = 1;
                    StringBuilder string2 = new StringBuilder("");
                    StringBuilder substring = new StringBuilder("");
                    this.next();
                    while (!(this.thisToken() instanceof Tokenizer.END)) {
                        if (this.thisToken() instanceof Tokenizer.CODE_START) {
                            ++i;
                        }
                        if (this.thisToken() instanceof Tokenizer.CODE_END) {
                            if (--i == 0) {
                                string2.append((CharSequence)substring);
                                break;
                            }
                            string2.append((CharSequence)substring);
                            substring.delete(0, substring.length());
                            tmp = this.getTokenIndex() + 1;
                        }
                        substring.append(this.thisToken().value);
                        this.next();
                    }
                    if (i == 0) {
                        codeView = (CodeView)LayoutInflater.from((Context)this.mContext).inflate(R.layout.code_view, (ViewGroup)this, false);
                        codeView.setCode(string2.toString());
                        ret.add(codeView);
                    } else if (!TextUtils.isEmpty((CharSequence)string2)) {
                        this.setTokenIndex(tmp);
                        codeView = (CodeView)LayoutInflater.from((Context)this.mContext).inflate(R.layout.code_view, (ViewGroup)this, false);
                        codeView.setCode(string2.toString());
                        ret.add(codeView);
                    } else {
                        this.setTokenIndex(tmp);
                        this.append(ret, (Object)new TextWithFormula(this.thisToken().value));
                    }
                } else if (this.thisToken() instanceof Tokenizer.IMAGE) {
                    Tokenizer.IMAGE thisToken = (Tokenizer.IMAGE)this.thisToken();
                    FImageView imageView = this.loadImage(thisToken.url, thisToken.width, thisToken.height);
                    if (this.mCenter) {
                        imageView.centered = true;
                    }
                    this.append(ret, (Object)imageView);
                } else if (this.thisToken() instanceof Tokenizer.TABLE) {
                    View table = this.table(this.thisToken().value);
                    this.append(ret, table);
                } else if (this.thisToken() instanceof Tokenizer.ATTACHMENT) {
                    Tokenizer.ATTACHMENT thisToken = (Tokenizer.ATTACHMENT)this.thisToken();
                    this.append(ret, this.attachment(thisToken.attachment));
                } else if (this.thisToken() instanceof Tokenizer.QUOTE_START) {
                    i = 1;
                    ArrayList<Tokenizer.TOKEN> tokens = new ArrayList<Tokenizer.TOKEN>();
                    this.next();
                    while (!(this.thisToken() instanceof Tokenizer.END)) {
                        if (this.thisToken() instanceof Tokenizer.QUOTE_START) {
                            ++i;
                            while (i > 0) {
                                this.next();
                                if (this.thisToken() instanceof Tokenizer.QUOTE_START) {
                                    ++i;
                                    continue;
                                }
                                if (!(this.thisToken() instanceof Tokenizer.QUOTE_END)) continue;
                                --i;
                            }
                        } else {
                            if (this.thisToken() instanceof Tokenizer.QUOTE_END) {
                                tokens.add(new Tokenizer.END(this.thisToken().position));
                                break;
                            }
                            tokens.add(this.thisToken());
                        }
                        this.next();
                    }
                    if (this.thisToken() instanceof Tokenizer.QUOTE_END) {
                        QuoteView quoteView = QuoteView.newInstance((ViewGroup)this, this.mQuoteViewId);
                        quoteView.setAttachmentList(this.mAttachmentList);
                        quoteView.setPadding(0, 8, 0, 8);
                        quoteView.setTokens(tokens);
                        quoteView.setOnButtonClickListener(this.mOnViewClickListener);
                        ret.add((Object)quoteView);
                    } else {
                        this.append(ret, (Object)new TextWithFormula(this.thisToken().value));
                    }
                }
            }
            this.next();
        }
        if (endClass.isInstance(this.thisToken())) {
            return ret;
        }
        return null;
    }

    private Object attachment(final Attachment attachment) {
        if (attachment.isImage()) {
            String url = attachment.getUrl();
            FImageView imageView = this.loadImage(url);
            if (this.mCenter) {
                imageView.centered = true;
            }
            return imageView;
        }
        TextWithFormula builder = new TextWithFormula(attachment.getText());
        builder.setSpan(new ClickableSpan(){

            public void onClick(View view) {
                if (FlexibleRichTextView.this.mOnViewClickListener != null) {
                    FlexibleRichTextView.this.mOnViewClickListener.onAttClick(attachment);
                }
            }
        }, 0, attachment.getText().length(), 17);
        builder.append("\n\n");
        return builder;
    }

    private void append(List<Object> list, Object element) {
        this.concat(list, Collections.singletonList(element));
    }

    private FImageView loadImage(String url) {
        return this.loadImage(url, -1);
    }

    private FImageView loadImage(String url, int size) {
        return this.loadImage(url, size, size);
    }

    private FImageView loadImage(String url, int width, int height) {
        RelativeLayout.LayoutParams layoutParams;
        int phWidth;
        int phHeight;
        int imgWidth;
        int imgHeight;
        final FImageView imageView = new FImageView(this.mContext);
        if (height != -1 && width != -1) {
            imgHeight = height;
            imgWidth = width;
            phHeight = height;
            phWidth = width;
        } else if (width != -1) {
            imgHeight = -2;
            imgWidth = width;
            phHeight = MAX_IMAGE_WIDTH / 2;
            phWidth = width;
        } else if (height != -1) {
            imgHeight = height;
            imgWidth = -2;
            phHeight = height;
            phWidth = MAX_IMAGE_WIDTH;
        } else {
            imgWidth = -2;
            imgHeight = -2;
            phHeight = MAX_IMAGE_WIDTH / 2;
            phWidth = MAX_IMAGE_WIDTH;
        }
        if (imageView.centered) {
            layoutParams = new RelativeLayout.LayoutParams(phWidth, phHeight);
            layoutParams.addRule(14, -1);
        } else {
            layoutParams = new LinearLayout.LayoutParams(phWidth, phHeight);
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageView.setAdjustViewBounds(true);
        imageView.setPadding(0, 0, 0, 10);
        final int finalWidth = imgWidth;
        final int finalHeight = imgHeight;
        Glide.with((Context)this.mContext).load(url).placeholder((Drawable)new ColorDrawable(ContextCompat.getColor((Context)this.mContext, (int)0x1060000))).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                if (imageView.centered) {
                    RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(finalWidth, finalHeight);
                    params.addRule(14, -1);
                    imageView.setLayoutParams((ViewGroup.LayoutParams)params);
                } else {
                    imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(finalWidth, finalHeight));
                }
                imageView.setImageDrawable((Drawable)resource);
                imageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FlexibleRichTextView.this.mOnViewClickListener != null) {
                            FlexibleRichTextView.this.mOnViewClickListener.onImgClick(imageView);
                        }
                    }
                });
                return false;
            }
        }).into((ImageView)imageView);
        return imageView;
    }

    private List<Object> operate(List<Object> list, String operation, final String ... operand) {
        switch (operation) {
            case "bold": {
                for (Object o : list) {
                    if (!(o instanceof TextWithFormula)) continue;
                    TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                    textWithFormula.setSpan(new StyleSpan(1), 0, textWithFormula.length(), 17);
                }
                break;
            }
            case "center": {
                for (Object o : list) {
                    if (o instanceof TextWithFormula) {
                        TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                        textWithFormula.setSpan(new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER), 0, textWithFormula.length(), 17);
                        continue;
                    }
                    if (!(o instanceof ImageView)) continue;
                    ((ImageView)o).setScaleType(ImageView.ScaleType.CENTER);
                }
                break;
            }
            case "italic": {
                for (Object o : list) {
                    if (!(o instanceof TextWithFormula)) continue;
                    TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                    textWithFormula.setSpan(new StyleSpan(2), 0, textWithFormula.length(), 17);
                }
                break;
            }
            case "underline": {
                for (Object o : list) {
                    if (!(o instanceof TextWithFormula)) continue;
                    TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                    textWithFormula.setSpan(new UnderlineSpan(), 0, textWithFormula.length(), 17);
                }
                break;
            }
            case "delete": {
                for (Object o : list) {
                    if (!(o instanceof TextWithFormula)) continue;
                    TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                    textWithFormula.setSpan(new StrikethroughSpan(), 0, textWithFormula.length(), 17);
                }
                break;
            }
            case "curtain": {
                for (Object o : list) {
                    if (!(o instanceof TextWithFormula)) continue;
                    TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                    textWithFormula.setSpan(new BackgroundColorSpan(-12303292), 0, textWithFormula.length(), 17);
                }
                break;
            }
            case "title": {
                for (Object o : list) {
                    if (!(o instanceof TextWithFormula)) continue;
                    TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                    textWithFormula.setSpan(new RelativeSizeSpan(1.3f), 0, textWithFormula.length(), 17);
                }
                break;
            }
            case "color": {
                for (Object o : list) {
                    if (!(o instanceof TextWithFormula)) continue;
                    TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                    try {
                        int color2 = Color.parseColor((String)operand[0]);
                        textWithFormula.setSpan(new ForegroundColorSpan(color2), 0, textWithFormula.length(), 17);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                break;
            }
            case "url": {
                for (Object o : list) {
                    if (!(o instanceof TextWithFormula)) continue;
                    TextWithFormula textWithFormula = (TextWithFormula)((Object)o);
                    textWithFormula.setSpan(new ClickableSpan(){

                        public void onClick(View widget) {
                            FlexibleRichTextView.this.mContext.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)operand[0])));
                        }
                    }, 0, textWithFormula.length(), 17);
                }
                break;
            }
        }
        return list;
    }

    private List<Object> operate(List<Object> list, String operation) {
        return this.operate(list, operation, "");
    }

    private <T> void concat(List<Object> list1, List<T> list2) {
        if (list1.size() == 0) {
            list1.addAll(list2);
        } else if (list2.size() > 0) {
            if (list1.get(list1.size() - 1) instanceof TextWithFormula && list2.get(0) instanceof TextWithFormula) {
                TextWithFormula a = (TextWithFormula)((Object)list1.get(list1.size() - 1));
                TextWithFormula b = (TextWithFormula)((Object)list2.get(0));
                for (TextWithFormula.Formula formula : b.getFormulas()) {
                    formula.start += a.length();
                    formula.end += a.length();
                    formula.contentStart += a.length();
                    formula.contentEnd += a.length();
                }
                a.getFormulas().addAll(b.getFormulas());
                a.append((CharSequence)((Object)b));
                list1.addAll(list2.subList(1, list2.size()));
            } else {
                list1.addAll(list2);
            }
        }
    }

    private Tokenizer.TOKEN thisToken() {
        return this.mTokenList.get(this.mTokenIndex);
    }

    private void next() {
        ++this.mTokenIndex;
    }

    public int getTokenIndex() {
        return this.mTokenIndex;
    }

    public void setTokenIndex(int tokenIndex) {
        this.mTokenIndex = tokenIndex;
    }

    /*
     * WARNING - void declaration
     */
    private View table(CharSequence str) {
        String SPECIAL_CHAR = "\uf487";
        Pattern pattern = Pattern.compile("(?:\\n|^)( *\\|.+\\| *\\n)??( *\\|(?: *:?----*:? *\\|)+ *\\n)((?: *\\|.+\\| *(?:\\n|$))+)");
        Matcher matcher = pattern.matcher(str);
        boolean LEFT = false;
        boolean RIGHT = true;
        int CENTER = 2;
        if (matcher.find()) {
            void var16_19;
            ArrayList<String> headers = null;
            if (!TextUtils.isEmpty((CharSequence)matcher.group(1))) {
                String wholeHeader = matcher.group(1);
                headers = new ArrayList<String>(Arrays.asList(wholeHeader.split("\\|")));
                this.format(headers);
            }
            ArrayList<String> partitions = new ArrayList<String>(Arrays.asList(matcher.group(2).split("\\|")));
            this.format(partitions);
            int columnNum = partitions.size();
            int[] margins = new int[columnNum];
            for (int i = 0; i < partitions.size(); ++i) {
                String partition = (String)partitions.get(i);
                margins[i] = partition.startsWith(":") && partition.endsWith(":") ? 2 : (partition.startsWith(":") ? 0 : (partition.endsWith(":") ? 1 : 2));
            }
            String[] rows = matcher.group(3).replace("\\|", "\uf487").split("\n");
            ArrayList<List<String>> content = new ArrayList<List<String>>();
            String[] stringArray = rows;
            int n = stringArray.length;
            boolean bl = false;
            while (var16_19 < n) {
                String row = stringArray[var16_19];
                content.add(this.format(new ArrayList<String>(Arrays.asList(row.split("\\|")))));
                ++var16_19;
            }
            ArrayList<String[]> whole = new ArrayList<String[]>();
            if (headers != null) {
                whole.add(headers.toArray(new String[columnNum]));
            }
            for (List list : content) {
                whole.add(list.toArray(new String[columnNum]));
            }
            HorizontalScrollView scrollView = new HorizontalScrollView(this.getContext());
            TableLayout tableLayout = new TableLayout(this.mContext);
            tableLayout.addView(this.getHorizontalDivider());
            for (int i = 0; i < whole.size(); ++i) {
                String[] row = (String[])whole.get(i);
                TableRow tableRow = new TableRow(this.mContext);
                TableLayout.LayoutParams params = new TableLayout.LayoutParams(-1, -2);
                tableRow.setLayoutParams((ViewGroup.LayoutParams)params);
                tableRow.addView(this.getVerticalDivider());
                for (int j = 0; j < row.length; ++j) {
                    String cell = row[j];
                    if (cell != null) {
                        cell = cell.replace("\uf487", "|");
                    }
                    FlexibleRichTextView flexibleRichTextView = FlexibleRichTextView.newInstance(this.getContext(), cell, this.mAttachmentList, this.mOnViewClickListener, false);
                    TableRow.LayoutParams pcvParams = new TableRow.LayoutParams(-1, -2);
                    switch (margins[j]) {
                        case 2: {
                            pcvParams.gravity = 17;
                            break;
                        }
                        case 0: {
                            pcvParams.gravity = 0x800003;
                            break;
                        }
                        case 1: {
                            pcvParams.gravity = 0x800005;
                        }
                    }
                    flexibleRichTextView.setPadding(10, 10, 10, 10);
                    flexibleRichTextView.setLayoutParams((ViewGroup.LayoutParams)pcvParams);
                    tableRow.addView((View)flexibleRichTextView);
                    tableRow.addView(this.getVerticalDivider());
                }
                tableLayout.addView((View)tableRow);
                tableLayout.addView(this.getHorizontalDivider());
            }
            scrollView.addView((View)tableLayout);
            return scrollView;
        }
        return null;
    }

    private List<String> format(List<String> strings) {
        int i;
        for (i = strings.size() - 1; i >= 0; --i) {
            String str = strings.get(i);
            if (!TextUtils.isEmpty((CharSequence)str) && !str.equals("\n")) continue;
            strings.remove(i);
        }
        for (i = 0; i < strings.size(); ++i) {
            strings.set(i, strings.get(i).trim());
        }
        return strings;
    }

    public static FlexibleRichTextView newInstance(Context context, String string2, List<Attachment> attachmentList, OnViewClickListener onViewClickListener, boolean showRemainingAtt) {
        FlexibleRichTextView flexibleRichTextView = new FlexibleRichTextView(context, onViewClickListener, showRemainingAtt);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            flexibleRichTextView.setText(string2, attachmentList);
        }
        return flexibleRichTextView;
    }

    private View getHorizontalDivider() {
        View horizontalDivider = new View(this.mContext);
        horizontalDivider.setLayoutParams((ViewGroup.LayoutParams)new TableLayout.LayoutParams(-1, 1));
        horizontalDivider.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)17170444));
        return horizontalDivider;
    }

    private View getVerticalDivider() {
        View verticalDivider = new View(this.mContext);
        verticalDivider.setLayoutParams((ViewGroup.LayoutParams)new TableRow.LayoutParams(1, -1));
        verticalDivider.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)17170444));
        return verticalDivider;
    }

    private void init(Context context) {
        this.init(context, null);
    }

    private void init(Context context, OnViewClickListener onViewClickListener) {
        this.init(context, onViewClickListener, true);
    }

    private void init(Context context, OnViewClickListener onViewClickListener, boolean showRemainingAtt) {
        this.setOrientation(1);
        this.mOnViewClickListener = onViewClickListener;
        this.mContext = context;
        this.mShowRemainingAtt = showRemainingAtt;
        this.removeAllViews();
    }

    public void setOnClickListener(OnViewClickListener onViewClickListener) {
        this.mOnViewClickListener = onViewClickListener;
    }

    public int getConversationId() {
        return this.mConversationId;
    }

    public void setConversationId(int mConversationId) {
        this.mConversationId = mConversationId;
    }

    public void setQuoteViewId(int quoteViewId) {
        this.mQuoteViewId = quoteViewId;
    }

    public static interface OnViewClickListener {
        public void onImgClick(ImageView var1);

        public void onAttClick(Attachment var1);

        public void onQuoteButtonClick(View var1, boolean var2);
    }
}

