/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;

public class HandlerThreadExtension
extends HandlerThread {
    private static final boolean SHOW_LOGS = true;
    private static final String TAG = HandlerThreadExtension.class.getSimpleName();
    private Handler mHandler;
    private final Object mStart = new Object();

    public HandlerThreadExtension(String name, boolean setupExceptionHandler) {
        super(name);
        if (setupExceptionHandler) {
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    Log.v((String)TAG, (String)("uncaughtException, " + ex.getMessage()));
                    ex.printStackTrace();
                    System.exit(0);
                }
            });
        }
    }

    protected void onLooperPrepared() {
        Log.v((String)TAG, (String)("onLooperPrepared " + (Object)((Object)this)));
        this.mHandler = new Handler();
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = HandlerThreadExtension.this.mStart;
                synchronized (object) {
                    HandlerThreadExtension.this.mStart.notifyAll();
                }
            }
        });
    }

    public void post(Runnable r) {
        boolean successfullyAddedToQueue = this.mHandler.post(r);
        Log.v((String)TAG, (String)("post, successfullyAddedToQueue " + successfullyAddedToQueue));
    }

    public void postAtFrontOfQueue(Runnable r) {
        this.mHandler.postAtFrontOfQueue(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread() {
        Log.v((String)TAG, (String)">> startThread");
        Object object = this.mStart;
        synchronized (object) {
            this.start();
            try {
                this.mStart.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Log.v((String)TAG, (String)"<< startThread");
    }

    public void postQuit() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.v((String)TAG, (String)"postQuit, run");
                Looper.myLooper().quit();
            }
        });
    }

    public void remove(Runnable runnable) {
        this.mHandler.removeCallbacks(runnable);
    }
}

