/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.ui;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.TextureView;

public abstract class ScalableTextureView
extends TextureView {
    private static final boolean SHOW_LOGS = false;
    private static final String TAG = ScalableTextureView.class.getSimpleName();
    private Integer mContentWidth;
    private Integer mContentHeight;
    private float mPivotPointX = 0.0f;
    private float mPivotPointY = 0.0f;
    private float mContentScaleX = 1.0f;
    private float mContentScaleY = 1.0f;
    private float mContentRotation = 0.0f;
    private float mContentScaleMultiplier = 1.0f;
    private int mContentX = 0;
    private int mContentY = 0;
    private final Matrix mTransformMatrix = new Matrix();
    private ScaleType mScaleType;

    public ScalableTextureView(Context context) {
        super(context);
    }

    public ScalableTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ScalableTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ScalableTextureView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setScaleType(ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mContentWidth != null && this.mContentHeight != null) {
            this.updateTextureViewSize();
        }
    }

    public void updateTextureViewSize() {
        float pivotPointY;
        float pivotPointX;
        if (this.mContentWidth == null || this.mContentHeight == null) {
            throw new RuntimeException("null content size");
        }
        float viewWidth = this.getMeasuredWidth();
        float viewHeight = this.getMeasuredHeight();
        float contentWidth = this.mContentWidth.intValue();
        float contentHeight = this.mContentHeight.intValue();
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        switch (this.mScaleType) {
            case FILL: {
                if (viewWidth > viewHeight) {
                    scaleX = viewHeight * contentWidth / (viewWidth * contentHeight);
                    break;
                }
                scaleY = viewWidth * contentHeight / (viewHeight * contentWidth);
                break;
            }
            case BOTTOM: 
            case CENTER_CROP: 
            case TOP: {
                if (contentWidth > viewWidth && contentHeight > viewHeight) {
                    scaleX = contentWidth / viewWidth;
                    scaleY = contentHeight / viewHeight;
                    break;
                }
                if (contentWidth < viewWidth && contentHeight < viewHeight) {
                    scaleY = viewWidth / contentWidth;
                    scaleX = viewHeight / contentHeight;
                    break;
                }
                if (viewWidth > contentWidth) {
                    scaleY = viewWidth / contentWidth / (viewHeight / contentHeight);
                    break;
                }
                if (!(viewHeight > contentHeight)) break;
                scaleX = viewHeight / contentHeight / (viewWidth / contentWidth);
            }
        }
        switch (this.mScaleType) {
            case TOP: {
                pivotPointX = 0.0f;
                pivotPointY = 0.0f;
                break;
            }
            case BOTTOM: {
                pivotPointX = viewWidth;
                pivotPointY = viewHeight;
                break;
            }
            case CENTER_CROP: {
                pivotPointX = viewWidth / 2.0f;
                pivotPointY = viewHeight / 2.0f;
                break;
            }
            case FILL: {
                pivotPointX = this.mPivotPointX;
                pivotPointY = this.mPivotPointY;
                break;
            }
            default: {
                throw new IllegalStateException("pivotPointX, pivotPointY for ScaleType " + (Object)((Object)this.mScaleType) + " are not defined");
            }
        }
        float fitCoef = 1.0f;
        switch (this.mScaleType) {
            case FILL: {
                break;
            }
            case BOTTOM: 
            case CENTER_CROP: 
            case TOP: {
                fitCoef = this.mContentHeight > this.mContentWidth ? viewWidth / (viewWidth * scaleX) : viewHeight / (viewHeight * scaleY);
            }
        }
        this.mContentScaleX = fitCoef * scaleX;
        this.mContentScaleY = fitCoef * scaleY;
        this.mPivotPointX = pivotPointX;
        this.mPivotPointY = pivotPointY;
        this.updateMatrixScaleRotate();
    }

    private void updateMatrixScaleRotate() {
        this.mTransformMatrix.reset();
        this.mTransformMatrix.setScale(this.mContentScaleX * this.mContentScaleMultiplier, this.mContentScaleY * this.mContentScaleMultiplier, this.mPivotPointX, this.mPivotPointY);
        this.mTransformMatrix.postRotate(this.mContentRotation, this.mPivotPointX, this.mPivotPointY);
        this.setTransform(this.mTransformMatrix);
    }

    private void updateMatrixTranslate() {
        float scaleX = this.mContentScaleX * this.mContentScaleMultiplier;
        float scaleY = this.mContentScaleY * this.mContentScaleMultiplier;
        this.mTransformMatrix.reset();
        this.mTransformMatrix.setScale(scaleX, scaleY, this.mPivotPointX, this.mPivotPointY);
        this.mTransformMatrix.postTranslate((float)this.mContentX, (float)this.mContentY);
        this.setTransform(this.mTransformMatrix);
    }

    public void setRotation(float degrees) {
        this.mContentRotation = degrees;
        this.updateMatrixScaleRotate();
    }

    public float getRotation() {
        return this.mContentRotation;
    }

    public void setPivotX(float pivotX) {
        this.mPivotPointX = pivotX;
    }

    public void setPivotY(float pivotY) {
        this.mPivotPointY = pivotY;
    }

    public float getPivotX() {
        return this.mPivotPointX;
    }

    public float getPivotY() {
        return this.mPivotPointY;
    }

    public float getContentAspectRatio() {
        return this.mContentWidth != null && this.mContentHeight != null ? (float)this.mContentWidth.intValue() / (float)this.mContentHeight.intValue() : 0.0f;
    }

    public final void setContentX(float x) {
        this.mContentX = (int)x - (this.getMeasuredWidth() - this.getScaledContentWidth()) / 2;
        this.updateMatrixTranslate();
    }

    public final void setContentY(float y) {
        this.mContentY = (int)y - (this.getMeasuredHeight() - this.getScaledContentHeight()) / 2;
        this.updateMatrixTranslate();
    }

    protected final float getContentX() {
        return this.mContentX;
    }

    protected final float getContentY() {
        return this.mContentY;
    }

    public void centralizeContent() {
        int measuredWidth = this.getMeasuredWidth();
        int measuredHeight = this.getMeasuredHeight();
        int scaledContentWidth = this.getScaledContentWidth();
        int scaledContentHeight = this.getScaledContentHeight();
        this.mContentX = 0;
        this.mContentY = 0;
        this.updateMatrixScaleRotate();
    }

    public Integer getScaledContentWidth() {
        return (int)(this.mContentScaleX * this.mContentScaleMultiplier * (float)this.getMeasuredWidth());
    }

    public Integer getScaledContentHeight() {
        return (int)(this.mContentScaleY * this.mContentScaleMultiplier * (float)this.getMeasuredHeight());
    }

    public float getContentScale() {
        return this.mContentScaleMultiplier;
    }

    public void setContentScale(float contentScale) {
        this.mContentScaleMultiplier = contentScale;
        this.updateMatrixScaleRotate();
    }

    protected final void setContentHeight(int height) {
        this.mContentHeight = height;
    }

    protected final Integer getContentHeight() {
        return this.mContentHeight;
    }

    protected final void setContentWidth(int width) {
        this.mContentWidth = width;
    }

    protected final Integer getContentWidth() {
        return this.mContentWidth;
    }

    public static enum ScaleType {
        CENTER_CROP,
        TOP,
        BOTTOM,
        FILL;

    }
}

