/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.ui;

import android.content.res.AssetFileDescriptor;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import com.volokh.danylo.video_player_manager.utils.Logger;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class MediaPlayerWrapper
implements MediaPlayer.OnErrorListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnVideoSizeChangedListener {
    private String TAG;
    private static final boolean SHOW_LOGS = true;
    public static final int POSITION_UPDATE_NOTIFYING_PERIOD = 1000;
    private ScheduledFuture<?> mFuture;
    private Surface mSurface;
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private final MediaPlayer mMediaPlayer;
    private final AtomicReference<State> mState = new AtomicReference();
    private MainThreadMediaPlayerListener mListener;
    private VideoStateListener mVideoStateListener;
    private ScheduledExecutorService mPositionUpdateNotifier = Executors.newScheduledThreadPool(1);
    private final Runnable mOnVideoPreparedMessage = new Runnable(){

        @Override
        public void run() {
            Logger.v(MediaPlayerWrapper.this.TAG, ">> run, onVideoPreparedMainThread");
            MediaPlayerWrapper.this.mListener.onVideoPreparedMainThread();
            Logger.v(MediaPlayerWrapper.this.TAG, "<< run, onVideoPreparedMainThread");
        }
    };
    private final Runnable mOnVideoStopMessage = new Runnable(){

        @Override
        public void run() {
            Logger.v(MediaPlayerWrapper.this.TAG, ">> run, onVideoStoppedMainThread");
            MediaPlayerWrapper.this.mListener.onVideoStoppedMainThread();
            Logger.v(MediaPlayerWrapper.this.TAG, "<< run, onVideoStoppedMainThread");
        }
    };
    private final Runnable mNotifyPositionUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            MediaPlayerWrapper.this.notifyPositionUpdated();
        }
    };

    protected MediaPlayerWrapper(MediaPlayer mediaPlayer) {
        this.TAG = "" + this;
        Logger.v(this.TAG, "constructor of MediaPlayerWrapper");
        Logger.v(this.TAG, "constructor of MediaPlayerWrapper, main Looper " + Looper.getMainLooper());
        Logger.v(this.TAG, "constructor of MediaPlayerWrapper, my Looper " + Looper.myLooper());
        if (Looper.myLooper() != null) {
            throw new RuntimeException("myLooper not null, a bug in some MediaPlayer implementation cause that listeners are not called at all. Please use a thread without Looper");
        }
        this.mMediaPlayer = mediaPlayer;
        this.mState.set(State.IDLE);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
        this.mMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        Logger.v(this.TAG, ">> prepare, mState " + this.mState);
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            switch (this.mState.get()) {
                case STOPPED: 
                case INITIALIZED: {
                    try {
                        this.mMediaPlayer.prepare();
                        this.mState.set(State.PREPARED);
                        if (this.mListener == null) break;
                        this.mMainThreadHandler.post(this.mOnVideoPreparedMessage);
                        break;
                    }
                    catch (IllegalStateException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        this.onPrepareError(ex);
                        break;
                    }
                }
                case IDLE: 
                case PREPARING: 
                case PREPARED: 
                case STARTED: 
                case PAUSED: 
                case PLAYBACK_COMPLETED: 
                case END: 
                case ERROR: {
                    throw new IllegalStateException("prepare, called from illegal state " + this.mState);
                }
            }
        }
        Logger.v(this.TAG, "<< prepare, mState " + this.mState);
    }

    private void onPrepareError(IOException ex) {
        Logger.err(this.TAG, "catch IO exception [" + ex + "]");
        this.mState.set(State.ERROR);
        if (this.mListener != null) {
            this.mListener.onErrorMainThread(1, -1004);
        }
        if (this.mListener != null) {
            this.mMainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    Logger.v(MediaPlayerWrapper.this.TAG, ">> run, onVideoPreparedMainThread");
                    MediaPlayerWrapper.this.mListener.onErrorMainThread(1, -1004);
                    Logger.v(MediaPlayerWrapper.this.TAG, "<< run, onVideoPreparedMainThread");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(String filePath) throws IOException {
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            Logger.v(this.TAG, "setDataSource, filePath " + filePath + ", mState " + this.mState);
            switch (this.mState.get()) {
                case IDLE: {
                    this.mMediaPlayer.setDataSource(filePath);
                    this.mState.set(State.INITIALIZED);
                    break;
                }
                default: {
                    throw new IllegalStateException("setDataSource called in state " + this.mState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(AssetFileDescriptor assetFileDescriptor) throws IOException {
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            switch (this.mState.get()) {
                case IDLE: {
                    this.mMediaPlayer.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
                    this.mState.set(State.INITIALIZED);
                    break;
                }
                default: {
                    throw new IllegalStateException("setDataSource called in state " + this.mState);
                }
            }
        }
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        Logger.v(this.TAG, "onVideoSizeChanged, width " + width + ", height " + height);
        if (!this.inUiThread()) {
            throw new RuntimeException("this should be called in Main Thread");
        }
        if (this.mListener != null) {
            this.mListener.onVideoSizeChangedMainThread(width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(MediaPlayer mp) {
        Logger.v(this.TAG, "onVideoCompletion, mState " + this.mState);
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            this.mState.set(State.PLAYBACK_COMPLETED);
        }
        if (this.mListener != null) {
            this.mListener.onVideoCompletionMainThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onError(MediaPlayer mp, int what, int extra) {
        Logger.v(this.TAG, "onErrorMainThread, what " + what + ", extra " + extra);
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            this.mState.set(State.ERROR);
        }
        if (this.positionUpdaterIsWorking()) {
            this.stopPositionUpdateNotifier();
        }
        Logger.v(this.TAG, "onErrorMainThread, mListener " + this.mListener);
        if (this.mListener != null) {
            this.mListener.onErrorMainThread(what, extra);
        }
        return true;
    }

    private boolean positionUpdaterIsWorking() {
        return this.mFuture != null;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        if (this.mListener != null) {
            this.mListener.onBufferingUpdateMainThread(percent);
        }
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        Logger.v(this.TAG, "onInfo");
        this.printInfo(what);
        return false;
    }

    private void printInfo(int what) {
        switch (what) {
            case 1: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_UNKNOWN");
                break;
            }
            case 700: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_VIDEO_TRACK_LAGGING");
                break;
            }
            case 3: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_VIDEO_RENDERING_START");
                break;
            }
            case 701: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_BUFFERING_START");
                break;
            }
            case 702: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_BUFFERING_END");
                break;
            }
            case 800: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_BAD_INTERLEAVING");
                break;
            }
            case 801: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_NOT_SEEKABLE");
                break;
            }
            case 802: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_METADATA_UPDATE");
                break;
            }
            case 901: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_UNSUPPORTED_SUBTITLE");
                break;
            }
            case 902: {
                Logger.inf(this.TAG, "onInfo, MEDIA_INFO_SUBTITLE_TIMED_OUT");
            }
        }
    }

    public void setMainThreadMediaPlayerListener(MainThreadMediaPlayerListener listener) {
        this.mListener = listener;
    }

    public void setVideoStateListener(VideoStateListener listener) {
        this.mVideoStateListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Logger.v(this.TAG, ">> start");
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            Logger.v(this.TAG, "start, mState " + this.mState);
            switch (this.mState.get()) {
                case INITIALIZED: 
                case IDLE: 
                case PREPARING: 
                case STARTED: {
                    throw new IllegalStateException("start, called from illegal state " + this.mState);
                }
                case STOPPED: 
                case PREPARED: 
                case PAUSED: 
                case PLAYBACK_COMPLETED: {
                    Logger.v(this.TAG, "start, video is " + this.mState + ", starting playback.");
                    this.mMediaPlayer.start();
                    this.startPositionUpdateNotifier();
                    this.mState.set(State.STARTED);
                    break;
                }
                case END: 
                case ERROR: {
                    throw new IllegalStateException("start, called from illegal state " + this.mState);
                }
            }
        }
        Logger.v(this.TAG, "<< start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Logger.v(this.TAG, ">> pause");
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            Logger.v(this.TAG, "pause, mState " + this.mState);
            switch (this.mState.get()) {
                case STOPPED: 
                case INITIALIZED: 
                case IDLE: 
                case PREPARING: 
                case PREPARED: 
                case PAUSED: 
                case PLAYBACK_COMPLETED: 
                case END: 
                case ERROR: {
                    throw new IllegalStateException("pause, called from illegal state " + this.mState);
                }
                case STARTED: {
                    this.mMediaPlayer.pause();
                    this.mState.set(State.PAUSED);
                }
            }
        }
        Logger.v(this.TAG, "<< pause");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Logger.v(this.TAG, ">> stop");
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            Logger.v(this.TAG, "stop, mState " + this.mState);
            switch (this.mState.get()) {
                case STARTED: 
                case PAUSED: {
                    this.stopPositionUpdateNotifier();
                }
                case PREPARING: 
                case PREPARED: 
                case PLAYBACK_COMPLETED: {
                    Logger.v(this.TAG, ">> stop");
                    this.mMediaPlayer.stop();
                    Logger.v(this.TAG, "<< stop");
                    this.mState.set(State.STOPPED);
                    if (this.mListener == null) break;
                    this.mMainThreadHandler.post(this.mOnVideoStopMessage);
                    break;
                }
                case STOPPED: {
                    throw new IllegalStateException("stop, already stopped");
                }
                case INITIALIZED: 
                case IDLE: 
                case END: 
                case ERROR: {
                    throw new IllegalStateException("cannot stop. Player in mState " + this.mState);
                }
            }
        }
        Logger.v(this.TAG, "<< stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Logger.v(this.TAG, ">> reset , mState " + this.mState);
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            switch (this.mState.get()) {
                case STOPPED: 
                case INITIALIZED: 
                case IDLE: 
                case PREPARED: 
                case STARTED: 
                case PAUSED: 
                case PLAYBACK_COMPLETED: 
                case ERROR: {
                    this.mMediaPlayer.reset();
                    this.mState.set(State.IDLE);
                    break;
                }
                case PREPARING: 
                case END: {
                    throw new IllegalStateException("cannot call reset from state " + (Object)((Object)this.mState.get()));
                }
            }
        }
        Logger.v(this.TAG, "<< reset , mState " + this.mState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Logger.v(this.TAG, ">> release, mState " + this.mState);
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            this.mMediaPlayer.release();
            this.mState.set(State.END);
        }
        Logger.v(this.TAG, "<< release, mState " + this.mState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Logger.v(this.TAG, ">> clearAll, mState " + this.mState);
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnBufferingUpdateListener(null);
            this.mMediaPlayer.setOnInfoListener(null);
        }
        Logger.v(this.TAG, "<< clearAll, mState " + this.mState);
    }

    public void setLooping(boolean looping) {
        Logger.v(this.TAG, "setLooping " + looping);
        this.mMediaPlayer.setLooping(looping);
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        Logger.v(this.TAG, ">> setSurfaceTexture " + surfaceTexture);
        Logger.v(this.TAG, "setSurfaceTexture mSurface " + this.mSurface);
        if (surfaceTexture != null) {
            this.mSurface = new Surface(surfaceTexture);
            this.mMediaPlayer.setSurface(this.mSurface);
        } else {
            this.mMediaPlayer.setSurface(null);
        }
        Logger.v(this.TAG, "<< setSurfaceTexture " + surfaceTexture);
    }

    public void setVolume(float leftVolume, float rightVolume) {
        this.mMediaPlayer.setVolume(leftVolume, rightVolume);
    }

    public int getVideoWidth() {
        return this.mMediaPlayer.getVideoWidth();
    }

    public int getVideoHeight() {
        return this.mMediaPlayer.getVideoHeight();
    }

    public int getCurrentPosition() {
        return this.mMediaPlayer.getCurrentPosition();
    }

    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadyForPlayback() {
        boolean isReadyForPlayback = false;
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            Logger.v(this.TAG, "isReadyForPlayback, mState " + this.mState);
            State state = this.mState.get();
            switch (state) {
                case STOPPED: 
                case INITIALIZED: 
                case IDLE: 
                case PREPARING: 
                case END: 
                case ERROR: {
                    isReadyForPlayback = false;
                    break;
                }
                case PREPARED: 
                case STARTED: 
                case PAUSED: 
                case PLAYBACK_COMPLETED: {
                    isReadyForPlayback = true;
                }
            }
        }
        return isReadyForPlayback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDuration() {
        int duration = 0;
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            switch (this.mState.get()) {
                case INITIALIZED: 
                case IDLE: 
                case PREPARING: 
                case END: 
                case ERROR: {
                    duration = 0;
                    break;
                }
                case STOPPED: 
                case PREPARED: 
                case STARTED: 
                case PAUSED: 
                case PLAYBACK_COMPLETED: {
                    duration = this.mMediaPlayer.getDuration();
                }
            }
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seekToPercent(int percent) {
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            State state = this.mState.get();
            Logger.v(this.TAG, "seekToPercent, percent " + percent + ", mState " + (Object)((Object)state));
            switch (state) {
                case STOPPED: 
                case INITIALIZED: 
                case IDLE: 
                case PREPARING: 
                case END: 
                case ERROR: {
                    Logger.w(this.TAG, "seekToPercent, illegal state");
                    break;
                }
                case PREPARED: 
                case STARTED: 
                case PAUSED: 
                case PLAYBACK_COMPLETED: {
                    int positionMillis = (int)((float)percent / 100.0f * (float)this.getDuration());
                    this.mMediaPlayer.seekTo(positionMillis);
                    this.notifyPositionUpdated();
                }
            }
        }
    }

    private void startPositionUpdateNotifier() {
        Logger.v(this.TAG, "startPositionUpdateNotifier, mPositionUpdateNotifier " + this.mPositionUpdateNotifier);
        this.mFuture = this.mPositionUpdateNotifier.scheduleAtFixedRate(this.mNotifyPositionUpdateRunnable, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void stopPositionUpdateNotifier() {
        Logger.v(this.TAG, "stopPositionUpdateNotifier, mPositionUpdateNotifier " + this.mPositionUpdateNotifier);
        this.mFuture.cancel(true);
        this.mFuture = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPositionUpdated() {
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            if (this.mVideoStateListener != null && this.mState.get() == State.STARTED) {
                this.mVideoStateListener.onVideoPlayTimeChanged(this.mMediaPlayer.getCurrentPosition());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getCurrentState() {
        AtomicReference<State> atomicReference = this.mState;
        synchronized (atomicReference) {
            return this.mState.get();
        }
    }

    public static int positionToPercent(int progressMillis, int durationMillis) {
        float percentPrecise = (float)progressMillis / (float)durationMillis * 100.0f;
        return Math.round(percentPrecise);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode();
    }

    private boolean inUiThread() {
        return Thread.currentThread().getId() == 1L;
    }

    public static interface VideoStateListener {
        public void onVideoPlayTimeChanged(int var1);
    }

    public static interface MainThreadMediaPlayerListener {
        public void onVideoSizeChangedMainThread(int var1, int var2);

        public void onVideoPreparedMainThread();

        public void onVideoCompletionMainThread();

        public void onErrorMainThread(int var1, int var2);

        public void onBufferingUpdateMainThread(int var1);

        public void onVideoStoppedMainThread();
    }

    public static enum State {
        IDLE,
        INITIALIZED,
        PREPARING,
        PREPARED,
        STARTED,
        PAUSED,
        STOPPED,
        PLAYBACK_COMPLETED,
        END,
        ERROR;

    }
}

