/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.player_messages;

import com.volokh.danylo.video_player_manager.PlayerMessageState;
import com.volokh.danylo.video_player_manager.manager.VideoPlayerManagerCallback;
import com.volokh.danylo.video_player_manager.player_messages.PlayerMessage;
import com.volokh.danylo.video_player_manager.ui.VideoPlayerView;
import com.volokh.danylo.video_player_manager.utils.Logger;

public class Start
extends PlayerMessage {
    private static final boolean SHOW_LOGS = true;
    private static final String TAG = Start.class.getSimpleName();
    private PlayerMessageState mResultPlayerMessageState;

    public Start(VideoPlayerView videoPlayerView, VideoPlayerManagerCallback callback) {
        super(videoPlayerView, callback);
    }

    @Override
    protected void performAction(VideoPlayerView currentPlayer) {
        PlayerMessageState currentState = this.getCurrentState();
        Logger.d(TAG, "currentState " + (Object)((Object)currentState));
        switch (currentState) {
            case SETTING_NEW_PLAYER: 
            case IDLE: 
            case INITIALIZED: 
            case PREPARING: 
            case PREPARED: 
            case RELEASING: 
            case RELEASED: 
            case RESETTING: 
            case RESET: 
            case CLEARING_PLAYER_INSTANCE: 
            case PLAYER_INSTANCE_CLEARED: 
            case CREATING_PLAYER_INSTANCE: 
            case PLAYER_INSTANCE_CREATED: 
            case SETTING_DATA_SOURCE: 
            case DATA_SOURCE_SET: 
            case PLAYBACK_COMPLETED: 
            case END: {
                throw new RuntimeException("unhandled current state " + (Object)((Object)currentState));
            }
            case STARTING: {
                currentPlayer.start();
                this.mResultPlayerMessageState = PlayerMessageState.STARTED;
                break;
            }
            case ERROR: {
                this.mResultPlayerMessageState = PlayerMessageState.ERROR;
                break;
            }
            case STARTED: 
            case PAUSING: 
            case PAUSED: 
            case STOPPING: 
            case STOPPED: {
                throw new RuntimeException("unhandled current state " + (Object)((Object)currentState));
            }
        }
    }

    @Override
    protected PlayerMessageState stateBefore() {
        PlayerMessageState result = null;
        PlayerMessageState currentState = this.getCurrentState();
        Logger.d(TAG, "stateBefore, currentState " + (Object)((Object)currentState));
        switch (currentState) {
            case PREPARED: {
                result = PlayerMessageState.STARTING;
                break;
            }
            case SETTING_NEW_PLAYER: 
            case IDLE: 
            case INITIALIZED: 
            case PREPARING: 
            case RELEASING: 
            case RELEASED: 
            case RESETTING: 
            case RESET: 
            case CLEARING_PLAYER_INSTANCE: 
            case PLAYER_INSTANCE_CLEARED: 
            case CREATING_PLAYER_INSTANCE: 
            case PLAYER_INSTANCE_CREATED: 
            case SETTING_DATA_SOURCE: 
            case DATA_SOURCE_SET: 
            case PLAYBACK_COMPLETED: 
            case END: 
            case STARTING: {
                throw new RuntimeException("unhandled current state " + (Object)((Object)currentState));
            }
            case ERROR: {
                result = PlayerMessageState.ERROR;
                break;
            }
            case STARTED: 
            case PAUSING: 
            case PAUSED: 
            case STOPPING: 
            case STOPPED: {
                throw new RuntimeException("unhandled current state " + (Object)((Object)currentState));
            }
        }
        return result;
    }

    @Override
    protected PlayerMessageState stateAfter() {
        return this.mResultPlayerMessageState;
    }
}

