/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.player_messages;

import com.volokh.danylo.video_player_manager.PlayerMessageState;
import com.volokh.danylo.video_player_manager.manager.VideoPlayerManagerCallback;
import com.volokh.danylo.video_player_manager.player_messages.PlayerMessage;
import com.volokh.danylo.video_player_manager.ui.MediaPlayerWrapper;
import com.volokh.danylo.video_player_manager.ui.VideoPlayerView;
import com.volokh.danylo.video_player_manager.utils.Logger;

public class Prepare
extends PlayerMessage {
    private static final boolean SHOW_LOGS = true;
    private static final String TAG = Prepare.class.getSimpleName();
    private PlayerMessageState mResultPlayerMessageState;

    public Prepare(VideoPlayerView videoPlayerView, VideoPlayerManagerCallback callback) {
        super(videoPlayerView, callback);
    }

    @Override
    protected void performAction(VideoPlayerView currentPlayer) {
        currentPlayer.prepare();
        MediaPlayerWrapper.State resultOfPrepare = currentPlayer.getCurrentState();
        Logger.v(TAG, "resultOfPrepare " + (Object)((Object)resultOfPrepare));
        switch (resultOfPrepare) {
            case IDLE: 
            case INITIALIZED: 
            case PREPARING: 
            case STARTED: 
            case PAUSED: 
            case STOPPED: 
            case PLAYBACK_COMPLETED: 
            case END: {
                throw new RuntimeException("unhandled state " + (Object)((Object)resultOfPrepare));
            }
            case PREPARED: {
                this.mResultPlayerMessageState = PlayerMessageState.PREPARED;
                break;
            }
            case ERROR: {
                this.mResultPlayerMessageState = PlayerMessageState.ERROR;
            }
        }
    }

    @Override
    protected PlayerMessageState stateBefore() {
        return PlayerMessageState.PREPARING;
    }

    @Override
    protected PlayerMessageState stateAfter() {
        return this.mResultPlayerMessageState;
    }
}

