/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.player_messages;

import com.volokh.danylo.video_player_manager.PlayerMessageState;
import com.volokh.danylo.video_player_manager.manager.VideoPlayerManagerCallback;
import com.volokh.danylo.video_player_manager.player_messages.Message;
import com.volokh.danylo.video_player_manager.ui.VideoPlayerView;
import com.volokh.danylo.video_player_manager.utils.Logger;

public abstract class PlayerMessage
implements Message {
    private static final String TAG = PlayerMessage.class.getSimpleName();
    private static final boolean SHOW_LOGS = true;
    private final VideoPlayerView mCurrentPlayer;
    private final VideoPlayerManagerCallback mCallback;

    public PlayerMessage(VideoPlayerView currentPlayer, VideoPlayerManagerCallback callback) {
        this.mCurrentPlayer = currentPlayer;
        this.mCallback = callback;
    }

    protected final PlayerMessageState getCurrentState() {
        return this.mCallback.getCurrentPlayerState();
    }

    @Override
    public final void polledFromQueue() {
        this.mCallback.setVideoPlayerState(this.mCurrentPlayer, this.stateBefore());
    }

    @Override
    public final void messageFinished() {
        this.mCallback.setVideoPlayerState(this.mCurrentPlayer, this.stateAfter());
    }

    @Override
    public final void runMessage() {
        Logger.v(TAG, ">> runMessage, " + this.getClass().getSimpleName());
        this.performAction(this.mCurrentPlayer);
        Logger.v(TAG, "<< runMessage, " + this.getClass().getSimpleName());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected abstract void performAction(VideoPlayerView var1);

    protected abstract PlayerMessageState stateBefore();

    protected abstract PlayerMessageState stateAfter();
}

