/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import com.volokh.danylo.video_player_manager.ui.MediaPlayerWrapper;
import com.volokh.danylo.video_player_manager.ui.MediaPlayerWrapperImpl;
import com.volokh.danylo.video_player_manager.ui.ReadyForPlaybackIndicator;
import com.volokh.danylo.video_player_manager.ui.ScalableTextureView;
import com.volokh.danylo.video_player_manager.utils.HandlerThreadExtension;
import com.volokh.danylo.video_player_manager.utils.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class VideoPlayerView
extends ScalableTextureView
implements TextureView.SurfaceTextureListener,
MediaPlayerWrapper.MainThreadMediaPlayerListener,
MediaPlayerWrapper.VideoStateListener {
    private static final boolean SHOW_LOGS = true;
    private String TAG;
    private static final String IS_VIDEO_MUTED = "IS_VIDEO_MUTED";
    private MediaPlayerWrapper mMediaPlayer;
    private HandlerThreadExtension mViewHandlerBackgroundThread;
    private BackgroundThreadMediaPlayerListener mMediaPlayerListenerBackgroundThread;
    private MediaPlayerWrapper.VideoStateListener mVideoStateListener;
    private TextureView.SurfaceTextureListener mLocalSurfaceTextureListener;
    private AssetFileDescriptor mAssetFileDescriptor;
    private String mPath;
    private final ReadyForPlaybackIndicator mReadyForPlaybackIndicator = new ReadyForPlaybackIndicator();
    private final Set<MediaPlayerWrapper.MainThreadMediaPlayerListener> mMediaPlayerMainThreadListeners = new HashSet<MediaPlayerWrapper.MainThreadMediaPlayerListener>();
    private final Runnable mVideoCompletionBackgroundThreadRunnable = new Runnable(){

        @Override
        public void run() {
            VideoPlayerView.this.mMediaPlayerListenerBackgroundThread.onVideoSizeChangedBackgroundThread(VideoPlayerView.this.getContentHeight(), VideoPlayerView.this.getContentWidth());
        }
    };
    private final Runnable mVideoPreparedBackgroundThreadRunnable = new Runnable(){

        @Override
        public void run() {
            VideoPlayerView.this.mMediaPlayerListenerBackgroundThread.onVideoPreparedBackgroundThread();
        }
    };
    private final Runnable mVideoSizeAvailableRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger.v(VideoPlayerView.this.TAG, ">> run, onVideoSizeAvailable");
            ReadyForPlaybackIndicator readyForPlaybackIndicator = VideoPlayerView.this.mReadyForPlaybackIndicator;
            synchronized (readyForPlaybackIndicator) {
                Logger.v(VideoPlayerView.this.TAG, "onVideoSizeAvailable, mReadyForPlaybackIndicator " + VideoPlayerView.this.mReadyForPlaybackIndicator);
                VideoPlayerView.this.mReadyForPlaybackIndicator.setVideoSize(VideoPlayerView.this.getContentHeight(), VideoPlayerView.this.getContentWidth());
                if (VideoPlayerView.this.mReadyForPlaybackIndicator.isReadyForPlayback()) {
                    Logger.v(VideoPlayerView.this.TAG, "run, onVideoSizeAvailable, notifyAll");
                    VideoPlayerView.this.mReadyForPlaybackIndicator.notifyAll();
                }
                Logger.v(VideoPlayerView.this.TAG, "<< run, onVideoSizeAvailable");
            }
            if (VideoPlayerView.this.mMediaPlayerListenerBackgroundThread != null) {
                VideoPlayerView.this.mMediaPlayerListenerBackgroundThread.onVideoSizeChangedBackgroundThread(VideoPlayerView.this.getContentHeight(), VideoPlayerView.this.getContentWidth());
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaPlayerWrapper.State getCurrentState() {
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            return this.mMediaPlayer.getCurrentState();
        }
    }

    public AssetFileDescriptor getAssetFileDescriptorDataSource() {
        return this.mAssetFileDescriptor;
    }

    public String getVideoUrlDataSource() {
        return this.mPath;
    }

    public VideoPlayerView(Context context) {
        super(context);
        this.initView();
    }

    public VideoPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public VideoPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    @TargetApi(value=21)
    public VideoPlayerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView();
    }

    private void checkThread() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("cannot be in main thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            this.mMediaPlayer.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            this.mMediaPlayer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPlayerInstance() {
        Logger.v(this.TAG, ">> clearPlayerInstance");
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            this.mReadyForPlaybackIndicator.setVideoSize(null, null);
            this.mMediaPlayer.clearAll();
            this.mMediaPlayer = null;
        }
        Logger.v(this.TAG, "<< clearPlayerInstance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewPlayerInstance() {
        Logger.v(this.TAG, ">> createNewPlayerInstance");
        Logger.v(this.TAG, "createNewPlayerInstance main Looper " + Looper.getMainLooper());
        Logger.v(this.TAG, "createNewPlayerInstance my Looper " + Looper.myLooper());
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            this.mMediaPlayer = new MediaPlayerWrapperImpl();
            this.mReadyForPlaybackIndicator.setVideoSize(null, null);
            this.mReadyForPlaybackIndicator.setFailedToPrepareUiForPlayback(false);
            if (this.mReadyForPlaybackIndicator.isSurfaceTextureAvailable()) {
                SurfaceTexture texture = this.getSurfaceTexture();
                Logger.v(this.TAG, "texture " + texture);
                this.mMediaPlayer.setSurfaceTexture(texture);
            } else {
                Logger.v(this.TAG, "texture not available");
            }
            this.mMediaPlayer.setMainThreadMediaPlayerListener(this);
            this.mMediaPlayer.setVideoStateListener(this);
        }
        Logger.v(this.TAG, "<< createNewPlayerInstance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            this.mMediaPlayer.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            this.mMediaPlayer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnVideoStopped() {
        ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener> listCopy;
        Logger.v(this.TAG, "notifyOnVideoStopped");
        Set<MediaPlayerWrapper.MainThreadMediaPlayerListener> set = this.mMediaPlayerMainThreadListeners;
        synchronized (set) {
            listCopy = new ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener>(this.mMediaPlayerMainThreadListeners);
        }
        for (MediaPlayerWrapper.MainThreadMediaPlayerListener listener : listCopy) {
            listener.onVideoStoppedMainThread();
        }
    }

    private boolean isVideoSizeAvailable() {
        boolean isVideoSizeAvailable = this.getContentHeight() != null && this.getContentWidth() != null;
        Logger.v(this.TAG, "isVideoSizeAvailable " + isVideoSizeAvailable);
        return isVideoSizeAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Logger.v(this.TAG, ">> start");
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            if (this.mReadyForPlaybackIndicator.isReadyForPlayback()) {
                this.mMediaPlayer.start();
            } else {
                Logger.v(this.TAG, "start, >> wait");
                if (!this.mReadyForPlaybackIndicator.isFailedToPrepareUiForPlayback()) {
                    try {
                        this.mReadyForPlaybackIndicator.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    Logger.v(this.TAG, "start, << wait");
                    if (this.mReadyForPlaybackIndicator.isReadyForPlayback()) {
                        this.mMediaPlayer.start();
                    } else {
                        Logger.w(this.TAG, "start, movie is not ready, Player become STARTED state, but it will actually don't play");
                    }
                } else {
                    Logger.w(this.TAG, "start, movie is not ready. Video size will not become available");
                }
            }
        }
        Logger.v(this.TAG, "<< start");
    }

    private void initView() {
        this.TAG = "" + this;
        Logger.v(this.TAG, "initView");
        this.setScaleType(ScalableTextureView.ScaleType.CENTER_CROP);
        super.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    public final void setSurfaceTextureListener(TextureView.SurfaceTextureListener listener) {
        this.mLocalSurfaceTextureListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(String path) {
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            Logger.v(this.TAG, "setDataSource, path " + path + ", this " + this);
            try {
                this.mMediaPlayer.setDataSource(path);
            }
            catch (IOException e) {
                Logger.d(this.TAG, e.getMessage());
                throw new RuntimeException(e);
            }
            this.mPath = path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(AssetFileDescriptor assetFileDescriptor) {
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            Logger.v(this.TAG, "setDataSource, assetFileDescriptor " + assetFileDescriptor + ", this " + this);
            try {
                this.mMediaPlayer.setDataSource(assetFileDescriptor);
            }
            catch (IOException e) {
                Logger.d(this.TAG, e.getMessage());
                throw new RuntimeException(e);
            }
            this.mAssetFileDescriptor = assetFileDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnVideoStateChangedListener(MediaPlayerWrapper.VideoStateListener listener) {
        this.mVideoStateListener = listener;
        this.checkThread();
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            this.mMediaPlayer.setVideoStateListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaPlayerListener(MediaPlayerWrapper.MainThreadMediaPlayerListener listener) {
        Set<MediaPlayerWrapper.MainThreadMediaPlayerListener> set = this.mMediaPlayerMainThreadListeners;
        synchronized (set) {
            this.mMediaPlayerMainThreadListeners.add(listener);
        }
    }

    public void setBackgroundThreadMediaPlayerListener(BackgroundThreadMediaPlayerListener listener) {
        this.mMediaPlayerListenerBackgroundThread = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVideoSizeChangedMainThread(int width, int height) {
        Logger.v(this.TAG, ">> onVideoSizeChangedMainThread, width " + width + ", height " + height);
        if (width != 0 && height != 0) {
            this.setContentWidth(width);
            this.setContentHeight(height);
            this.onVideoSizeAvailable();
        } else {
            Logger.w(this.TAG, "onVideoSizeChangedMainThread, size 0. Probably will be unable to start video");
            ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
            synchronized (readyForPlaybackIndicator) {
                this.mReadyForPlaybackIndicator.setFailedToPrepareUiForPlayback(true);
                this.mReadyForPlaybackIndicator.notifyAll();
            }
        }
        this.notifyOnVideoSizeChangedMainThread(width, height);
        Logger.v(this.TAG, "<< onVideoSizeChangedMainThread, width " + width + ", height " + height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnVideoSizeChangedMainThread(int width, int height) {
        ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener> listCopy;
        Logger.v(this.TAG, "notifyOnVideoSizeChangedMainThread, width " + width + ", height " + height);
        Set<MediaPlayerWrapper.MainThreadMediaPlayerListener> set = this.mMediaPlayerMainThreadListeners;
        synchronized (set) {
            listCopy = new ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener>(this.mMediaPlayerMainThreadListeners);
        }
        for (MediaPlayerWrapper.MainThreadMediaPlayerListener listener : listCopy) {
            listener.onVideoSizeChangedMainThread(width, height);
        }
    }

    @Override
    public void onVideoCompletionMainThread() {
        this.notifyOnVideoCompletionMainThread();
        if (this.mMediaPlayerListenerBackgroundThread != null) {
            this.mViewHandlerBackgroundThread.post(this.mVideoCompletionBackgroundThreadRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnVideoCompletionMainThread() {
        ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener> listCopy;
        Logger.v(this.TAG, "notifyVideoCompletionMainThread");
        Set<MediaPlayerWrapper.MainThreadMediaPlayerListener> set = this.mMediaPlayerMainThreadListeners;
        synchronized (set) {
            listCopy = new ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener>(this.mMediaPlayerMainThreadListeners);
        }
        for (MediaPlayerWrapper.MainThreadMediaPlayerListener listener : listCopy) {
            listener.onVideoCompletionMainThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnVideoPreparedMainThread() {
        ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener> listCopy;
        Logger.v(this.TAG, "notifyOnVideoPreparedMainThread");
        Set<MediaPlayerWrapper.MainThreadMediaPlayerListener> set = this.mMediaPlayerMainThreadListeners;
        synchronized (set) {
            listCopy = new ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener>(this.mMediaPlayerMainThreadListeners);
        }
        for (MediaPlayerWrapper.MainThreadMediaPlayerListener listener : listCopy) {
            listener.onVideoPreparedMainThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnErrorMainThread(int what, int extra) {
        ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener> listCopy;
        Logger.v(this.TAG, "notifyOnErrorMainThread");
        Set<MediaPlayerWrapper.MainThreadMediaPlayerListener> set = this.mMediaPlayerMainThreadListeners;
        synchronized (set) {
            listCopy = new ArrayList<MediaPlayerWrapper.MainThreadMediaPlayerListener>(this.mMediaPlayerMainThreadListeners);
        }
        for (MediaPlayerWrapper.MainThreadMediaPlayerListener listener : listCopy) {
            listener.onErrorMainThread(what, extra);
        }
    }

    @Override
    public void onVideoPreparedMainThread() {
        this.notifyOnVideoPreparedMainThread();
        if (this.mMediaPlayerListenerBackgroundThread != null) {
            this.mViewHandlerBackgroundThread.post(this.mVideoPreparedBackgroundThreadRunnable);
        }
    }

    @Override
    public void onErrorMainThread(final int what, final int extra) {
        Logger.v(this.TAG, "onErrorMainThread, this " + this);
        switch (what) {
            case 100: {
                Logger.v(this.TAG, "onErrorMainThread, what MEDIA_ERROR_SERVER_DIED");
                this.printErrorExtra(extra);
                break;
            }
            case 1: {
                Logger.v(this.TAG, "onErrorMainThread, what MEDIA_ERROR_UNKNOWN");
                this.printErrorExtra(extra);
            }
        }
        this.notifyOnErrorMainThread(what, extra);
        if (this.mMediaPlayerListenerBackgroundThread != null) {
            this.mViewHandlerBackgroundThread.post(new Runnable(){

                @Override
                public void run() {
                    VideoPlayerView.this.mMediaPlayerListenerBackgroundThread.onErrorBackgroundThread(what, extra);
                }
            });
        }
    }

    @Override
    public void onBufferingUpdateMainThread(int percent) {
    }

    @Override
    public void onVideoStoppedMainThread() {
        this.notifyOnVideoStopped();
    }

    private void printErrorExtra(int extra) {
        switch (extra) {
            case -1004: {
                Logger.v(this.TAG, "error extra MEDIA_ERROR_IO");
                break;
            }
            case -1007: {
                Logger.v(this.TAG, "error extra MEDIA_ERROR_MALFORMED");
                break;
            }
            case -1010: {
                Logger.v(this.TAG, "error extra MEDIA_ERROR_UNSUPPORTED");
                break;
            }
            case -110: {
                Logger.v(this.TAG, "error extra MEDIA_ERROR_TIMED_OUT");
            }
        }
    }

    private void onVideoSizeAvailable() {
        Logger.v(this.TAG, ">> onVideoSizeAvailable");
        this.updateTextureViewSize();
        if (this.isAttachedToWindow()) {
            this.mViewHandlerBackgroundThread.post(this.mVideoSizeAvailableRunnable);
        }
        Logger.v(this.TAG, "<< onVideoSizeAvailable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void muteVideo() {
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            PreferenceManager.getDefaultSharedPreferences((Context)this.getContext()).edit().putBoolean(IS_VIDEO_MUTED, true).commit();
            this.mMediaPlayer.setVolume(0.0f, 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unMuteVideo() {
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            PreferenceManager.getDefaultSharedPreferences((Context)this.getContext()).edit().putBoolean(IS_VIDEO_MUTED, false).commit();
            this.mMediaPlayer.setVolume(1.0f, 1.0f);
        }
    }

    public boolean isAllVideoMute() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.getContext()).getBoolean(IS_VIDEO_MUTED, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Logger.d(this.TAG, ">> pause ");
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            this.mMediaPlayer.pause();
        }
        Logger.d(this.TAG, "<< pause");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDuration() {
        ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
        synchronized (readyForPlaybackIndicator) {
            return this.mMediaPlayer.getDuration();
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        Logger.v(this.TAG, "onSurfaceTextureAvailable, width " + width + ", height " + height + ", this " + this);
        if (this.mLocalSurfaceTextureListener != null) {
            this.mLocalSurfaceTextureListener.onSurfaceTextureAvailable(surfaceTexture, width, height);
        }
        this.notifyTextureAvailable();
    }

    private void notifyTextureAvailable() {
        Logger.v(this.TAG, ">> notifyTextureAvailable");
        this.mViewHandlerBackgroundThread.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Logger.v(VideoPlayerView.this.TAG, ">> run notifyTextureAvailable");
                ReadyForPlaybackIndicator readyForPlaybackIndicator = VideoPlayerView.this.mReadyForPlaybackIndicator;
                synchronized (readyForPlaybackIndicator) {
                    if (VideoPlayerView.this.mMediaPlayer != null) {
                        VideoPlayerView.this.mMediaPlayer.setSurfaceTexture(VideoPlayerView.this.getSurfaceTexture());
                    } else {
                        VideoPlayerView.this.mReadyForPlaybackIndicator.setVideoSize(null, null);
                        Logger.v(VideoPlayerView.this.TAG, "mMediaPlayer null, cannot set surface texture");
                    }
                    VideoPlayerView.this.mReadyForPlaybackIndicator.setSurfaceTextureAvailable(true);
                    if (VideoPlayerView.this.mReadyForPlaybackIndicator.isReadyForPlayback()) {
                        Logger.v(VideoPlayerView.this.TAG, "notify ready for playback");
                        VideoPlayerView.this.mReadyForPlaybackIndicator.notifyAll();
                    }
                }
                Logger.v(VideoPlayerView.this.TAG, "<< run notifyTextureAvailable");
            }
        });
        Logger.v(this.TAG, "<< notifyTextureAvailable");
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        if (this.mLocalSurfaceTextureListener != null) {
            this.mLocalSurfaceTextureListener.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        Logger.v(this.TAG, "onSurfaceTextureDestroyed, surface " + surface);
        if (this.mLocalSurfaceTextureListener != null) {
            this.mLocalSurfaceTextureListener.onSurfaceTextureDestroyed(surface);
        }
        if (this.isAttachedToWindow()) {
            this.mViewHandlerBackgroundThread.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ReadyForPlaybackIndicator readyForPlaybackIndicator = VideoPlayerView.this.mReadyForPlaybackIndicator;
                    synchronized (readyForPlaybackIndicator) {
                        VideoPlayerView.this.mReadyForPlaybackIndicator.setSurfaceTextureAvailable(false);
                        VideoPlayerView.this.mReadyForPlaybackIndicator.notifyAll();
                    }
                }
            });
        }
        surface.release();
        return false;
    }

    public boolean isAttachedToWindow() {
        return this.mViewHandlerBackgroundThread != null;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.mLocalSurfaceTextureListener != null) {
            this.mLocalSurfaceTextureListener.onSurfaceTextureUpdated(surface);
        }
    }

    @Override
    public void onVideoPlayTimeChanged(int positionInMilliseconds) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Logger.v(this.TAG, ">> onAttachedToWindow");
        this.mViewHandlerBackgroundThread = new HandlerThreadExtension(this.TAG, false);
        this.mViewHandlerBackgroundThread.startThread();
        Logger.v(this.TAG, "<< onAttachedToWindow");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Logger.v(this.TAG, ">> onDetachedFromWindow");
        this.mViewHandlerBackgroundThread.postQuit();
        this.mViewHandlerBackgroundThread = null;
        Logger.v(this.TAG, "<< onDetachedFromWindow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        Logger.v(this.TAG, ">> onVisibilityChanged " + VideoPlayerView.visibilityStr(visibility));
        switch (visibility) {
            case 0: {
                break;
            }
            case 4: 
            case 8: {
                ReadyForPlaybackIndicator readyForPlaybackIndicator = this.mReadyForPlaybackIndicator;
                synchronized (readyForPlaybackIndicator) {
                    this.mReadyForPlaybackIndicator.notifyAll();
                    break;
                }
            }
        }
        Logger.v(this.TAG, "<< onVisibilityChanged");
    }

    private static String visibilityStr(int visibility) {
        switch (visibility) {
            case 0: {
                return "VISIBLE";
            }
            case 4: {
                return "INVISIBLE";
            }
            case 8: {
                return "GONE";
            }
        }
        throw new RuntimeException("unexpected");
    }

    public static interface PlaybackStartedListener {
        public void onPlaybackStarted();
    }

    public static interface BackgroundThreadMediaPlayerListener {
        public void onVideoSizeChangedBackgroundThread(int var1, int var2);

        public void onVideoPreparedBackgroundThread();

        public void onVideoCompletionBackgroundThread();

        public void onErrorBackgroundThread(int var1, int var2);
    }
}

