/*
 * Decompiled with CFR 0.152.
 */
package com.volokh.danylo.video_player_manager;

import com.volokh.danylo.video_player_manager.PlayerQueueLock;
import com.volokh.danylo.video_player_manager.player_messages.Message;
import com.volokh.danylo.video_player_manager.utils.Logger;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class MessagesHandlerThread {
    private static final String TAG = MessagesHandlerThread.class.getSimpleName();
    private static final boolean SHOW_LOGS = true;
    private final Queue<Message> mPlayerMessagesQueue = new ConcurrentLinkedQueue<Message>();
    private final PlayerQueueLock mQueueLock = new PlayerQueueLock();
    private final Executor mQueueProcessingThread = Executors.newSingleThreadExecutor();
    private AtomicBoolean mTerminated = new AtomicBoolean(false);
    private Message mLastMessage;

    public MessagesHandlerThread() {
        this.mQueueProcessingThread.execute(new Runnable(){

            @Override
            public void run() {
                Logger.v(TAG, "start worker thread");
                do {
                    MessagesHandlerThread.this.mQueueLock.lock(TAG);
                    Logger.v(TAG, "mPlayerMessagesQueue " + MessagesHandlerThread.this.mPlayerMessagesQueue);
                    if (MessagesHandlerThread.this.mPlayerMessagesQueue.isEmpty()) {
                        try {
                            Logger.v(TAG, "queue is empty, wait for new messages");
                            MessagesHandlerThread.this.mQueueLock.wait(TAG);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            throw new RuntimeException("InterruptedException");
                        }
                    }
                    MessagesHandlerThread.this.mLastMessage = (Message)MessagesHandlerThread.this.mPlayerMessagesQueue.poll();
                    MessagesHandlerThread.this.mLastMessage.polledFromQueue();
                    Logger.v(TAG, "poll mLastMessage " + MessagesHandlerThread.this.mLastMessage);
                    MessagesHandlerThread.this.mQueueLock.unlock(TAG);
                    Logger.v(TAG, "run, mLastMessage " + MessagesHandlerThread.this.mLastMessage);
                    MessagesHandlerThread.this.mLastMessage.runMessage();
                    MessagesHandlerThread.this.mQueueLock.lock(TAG);
                    MessagesHandlerThread.this.mLastMessage.messageFinished();
                    MessagesHandlerThread.this.mQueueLock.unlock(TAG);
                } while (!MessagesHandlerThread.this.mTerminated.get());
            }
        });
    }

    public void addMessage(Message message) {
        Logger.v(TAG, ">> addMessage, lock " + message);
        this.mQueueLock.lock(TAG);
        this.mPlayerMessagesQueue.add(message);
        this.mQueueLock.notify(TAG);
        Logger.v(TAG, "<< addMessage, unlock " + message);
        this.mQueueLock.unlock(TAG);
    }

    public void addMessages(List<? extends Message> messages) {
        Logger.v(TAG, ">> addMessages, lock " + messages);
        this.mQueueLock.lock(TAG);
        this.mPlayerMessagesQueue.addAll(messages);
        this.mQueueLock.notify(TAG);
        Logger.v(TAG, "<< addMessages, unlock " + messages);
        this.mQueueLock.unlock(TAG);
    }

    public void pauseQueueProcessing(String outer) {
        Logger.v(TAG, "pauseQueueProcessing, lock " + this.mQueueLock);
        this.mQueueLock.lock(outer);
    }

    public void resumeQueueProcessing(String outer) {
        Logger.v(TAG, "resumeQueueProcessing, unlock " + this.mQueueLock);
        this.mQueueLock.unlock(outer);
    }

    public void clearAllPendingMessages(String outer) {
        Logger.v(TAG, ">> clearAllPendingMessages, mPlayerMessagesQueue " + this.mPlayerMessagesQueue);
        if (!this.mQueueLock.isLocked(outer)) {
            throw new RuntimeException("cannot perform action, you are not holding a lock");
        }
        this.mPlayerMessagesQueue.clear();
        Logger.v(TAG, "<< clearAllPendingMessages, mPlayerMessagesQueue " + this.mPlayerMessagesQueue);
    }

    public void terminate() {
        this.mTerminated.set(true);
    }
}

