/*
 * Decompiled with CFR 0.152.
 */
package com.danylovolokh.androidlogger;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import com.volokh.danylo.vonalogger.VoNaLogger;
import java.io.File;
import java.io.IOException;

public class AndroidLogger {
    private static String mProcessName;
    private static VoNaLogger sVoNaLogger;

    private AndroidLogger() {
    }

    public static void stopLoggingAndGetLogFiles(final GetFilesCallback filesCallback) {
        sVoNaLogger.stopLoggingAndGetLogFiles(new com.volokh.danylo.vonalogger.GetFilesCallback(){

            public void onFilesReady(File[] logFiles) {
                filesCallback.onFiles(logFiles);
            }
        });
    }

    public static File[] stopLoggingAndGetLogFilesSync() {
        return sVoNaLogger.stopLoggingAndGetLogFilesSync();
    }

    public static File[] processPendingLogsStopAndGetLogFilesSync() {
        return sVoNaLogger.processPendingLogsStopAndGetLogFilesSync();
    }

    public static void processPendingLogsStopAndGetLogFiles(final GetFilesCallback filesCallback) {
        sVoNaLogger.processPendingLogsStopAndGetLogFiles(new com.volokh.danylo.vonalogger.GetFilesCallback(){

            public void onFilesReady(File[] logFiles) {
                filesCallback.onFiles(logFiles);
            }
        });
    }

    public static File[] getLoggingFilesSnapShot() {
        return sVoNaLogger.getLoggingFilesSnapShotSync();
    }

    public static void reinitAndroidLogger() throws IOException {
        sVoNaLogger.initVoNaLoggerAfterStopping();
    }

    public static int e(String TAG, String message) {
        return sVoNaLogger.writeLog(new Object[]{mProcessName, Thread.currentThread().getId(), "error", TAG, message});
    }

    public static int w(String TAG, String message) {
        return sVoNaLogger.writeLog(new Object[]{mProcessName, Thread.currentThread().getId(), "warn", TAG, message});
    }

    public static int d(String TAG, String message) {
        return sVoNaLogger.writeLog(new Object[]{mProcessName, Thread.currentThread().getId(), "debug", TAG, message});
    }

    public static int v(String TAG, String message) {
        return sVoNaLogger.writeLog(new Object[]{mProcessName, Thread.currentThread().getId(), "verbose", TAG, message});
    }

    public static int i(String TAG, String message) {
        return sVoNaLogger.writeLog(new Object[]{mProcessName, Thread.currentThread().getId(), "info", TAG, message});
    }

    public static void initialize(Context context, File directory, String logFileName, int logFileMaxSizeBytes, boolean showLogs) throws IOException {
        mProcessName = AndroidLogger.getProcessNameByPID(context, Process.myPid());
        mProcessName = mProcessName.replace(":", "_");
        mProcessName = mProcessName.replace(".", "_");
        sVoNaLogger = new VoNaLogger.Builder().setLoggerFilesDir(directory).setLoggerFileName(logFileName + "_" + mProcessName).setLogFileMaxSize((long)logFileMaxSizeBytes).setShowLogs(Boolean.valueOf(showLogs)).build();
    }

    public static File getDefaultLogFilesDirectory(Context context) {
        return context.getFilesDir();
    }

    private static String getProcessNameByPID(Context context, int pid) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
            if (processInfo.pid != pid) continue;
            return processInfo.processName;
        }
        return "";
    }

    public static interface GetFilesCallback {
        public void onFiles(File[] var1);
    }

    private static interface LogLevel {
        public static final String VERBOSE = "verbose";
        public static final String DEBUG = "debug";
        public static final String INFO = "info";
        public static final String WARN = "warn";
        public static final String ERROR = "error";
    }
}

