/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.ValidationException;
import java.util.ArrayList;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class GitHelper {
    public static boolean hasLocalTag(Git repo, String tagToCheck) throws GitAPIException {
        return GitHelper.tag(repo, new EqualsMatcher(tagToCheck)) != null;
    }

    public static Ref refStartingWith(Git repo, final String tagPrefix) throws GitAPIException {
        return GitHelper.tag(repo, new Matcher(){

            @Override
            public boolean matches(String tagName) {
                return tagName.startsWith(tagPrefix);
            }
        });
    }

    private static Ref tag(Git repo, Matcher matcher) throws GitAPIException {
        for (Ref ref : repo.tagList().call()) {
            String currentTag = ref.getName().replace("refs/tags/", "");
            if (!matcher.matches(currentTag)) continue;
            return ref;
        }
        return null;
    }

    public static String scmUrlToRemote(String scmUrl) throws ValidationException {
        String GIT_PREFIX = "scm:git:";
        if (!scmUrl.startsWith(GIT_PREFIX)) {
            ArrayList<String> messages = new ArrayList<String>();
            String summary = "Cannot run the release plugin with a non-Git version control system";
            messages.add(summary);
            messages.add("The value in your scm tag is " + scmUrl);
            throw new ValidationException(summary, messages);
        }
        String remote = scmUrl.substring(GIT_PREFIX.length());
        remote = remote.replace("file://localhost/", "file:///");
        return remote;
    }

    private static class EqualsMatcher
    implements Matcher {
        private final String tagToCheck;

        public EqualsMatcher(String tagToCheck) {
            this.tagToCheck = tagToCheck;
        }

        @Override
        public boolean matches(String tagName) {
            return this.tagToCheck.equals(tagName);
        }
    }

    private static interface Matcher {
        public boolean matches(String var1);
    }
}

