/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.FileRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.Formatter;
import com.github.danielflower.mavenplugins.gitlog.renderers.MarkdownLinkConverter;
import com.github.danielflower.mavenplugins.gitlog.renderers.MessageConverter;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;

public class MarkdownRenderer
extends FileRenderer {
    private boolean previousWasTag = false;
    private final boolean fullGitMessage;
    protected final MessageConverter messageConverter;
    private MarkdownLinkConverter markdownLinkConverter;

    public MarkdownRenderer(Log log, File targetFolder, String filename, boolean fullGitMessage, MessageConverter messageConverter) throws IOException {
        super(log, targetFolder, filename);
        this.fullGitMessage = fullGitMessage;
        this.messageConverter = messageConverter;
        this.markdownLinkConverter = new MarkdownLinkConverter(log);
    }

    @Override
    public void renderHeader(String reportTitle) throws IOException {
        if (reportTitle != null && reportTitle.length() > 0) {
            this.writer.write("# ");
            this.writer.write(reportTitle);
            this.writer.write(Formatter.NEW_LINE);
            this.writer.write(Formatter.NEW_LINE);
        }
    }

    @Override
    public void renderTag(RevTag tag) throws IOException {
        if (!this.previousWasTag) {
            this.writer.write(Formatter.NEW_LINE);
        }
        this.writer.write("**");
        this.writer.write(tag.getTagName());
        this.writer.write("**");
        this.writer.write("  ");
        this.writer.write(Formatter.NEW_LINE);
        this.previousWasTag = true;
    }

    @Override
    public void renderCommit(RevCommit commit) throws IOException {
        String message = null;
        message = this.fullGitMessage ? this.messageConverter.formatCommitMessage(MarkdownRenderer.markdownEncode(commit.getFullMessage())) : this.messageConverter.formatCommitMessage(MarkdownRenderer.markdownEncode(commit.getShortMessage()));
        message = this.markdownLinkConverter.formatCommitMessage(message);
        this.writer.write(Formatter.formatDateTime(commit.getCommitTime()) + "    " + message);
        this.writer.write(" (" + commit.getCommitterIdent().getName() + ")");
        this.writer.write("  ");
        this.writer.write(Formatter.NEW_LINE);
        this.previousWasTag = false;
    }

    @Override
    public void renderFooter() throws IOException {
    }

    static String markdownEncode(String input) {
        input = input.replaceAll("\\[", "\\\\[");
        input = input.replaceAll("\\]", "\\\\]");
        return input;
    }
}

