/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "com.github.danielflower.mavenplugins:maven-gitlog-plugin:1.7.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Git Log Plugin", 0);
        this.append(sb, "Generates a changelog based on commits to a git repository in text and HTML format showing the changes that are included in each version. A possible use of this is to include these changelogs when packaging your maven project so that you have an accurate list of commits that the current package includes.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "gitlog:generate", 0);
            this.append(sb, "Goal which generates a changelog based on commits made to the current git repo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dateFormat", 2);
                this.append(sb, "Used to set date format in log messages. If unspecified, will be used default format 'yyyy-MM-dd HH:mm:ss Z'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fullGitMessage (Default: false)", 2);
                this.append(sb, "If true, the changelog will include the full git message rather that the short git message", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateHTMLTableOnlyChangeLog (Default: false)", 2);
                this.append(sb, "If true, then an HTML changelog which contains only a table element will be generated. This incomplete HTML page is suitable for inclusion in other webpages, for example you may want to embed it in a wiki page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateJSONChangeLog (Default: true)", 2);
                this.append(sb, "If true, then a JSON changelog will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateMarkdownChangeLog (Default: false)", 2);
                this.append(sb, "If true, then a markdown changelog will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatePlainTextChangeLog (Default: true)", 2);
                this.append(sb, "If true, then a plain text changelog will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateSimpleHTMLChangeLog (Default: true)", 2);
                this.append(sb, "If true, then a simple HTML changelog will be generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "htmlTableOnlyChangeLogFilename (Default: changelogtable.html)", 2);
                this.append(sb, "The filename of the HTML table changelog, if generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeCommitsAfter (Default: 1970-01-01 00:00:00.0 AM)", 2);
                this.append(sb, "Include in the changelog the commits after this parameter value.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueManagementSystem", 2);
                this.append(sb, "Used to create links to your issue tracking system for HTML reports. If unspecified, it will try to use the value specified in the issueManagement section of your project's POM. The following values are supported: a value containing the string 'github' for the GitHub Issue tracking software; a value containing the string 'jira' for Jira tracking software. Any other value will result in no links being made.", 3);
                this.append(sb, "", 0);
                this.append(sb, "issueManagementUrl", 2);
                this.append(sb, "Used to create links to your issue tracking system for HTML reports. If unspecified, it will try to use the value specified in the issueManagement section of your project's POM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jsonChangeLogFilename (Default: changelog.json)", 2);
                this.append(sb, "The filename of the JSON changelog, if generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "markdownChangeLogFilename (Default: changelog.md)", 2);
                this.append(sb, "The filename of the markdown changelog, if generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The directory to put the reports in. Defaults to the project build directory (normally target).", 3);
                this.append(sb, "", 0);
                this.append(sb, "plainTextChangeLogFilename (Default: changelog.txt)", 2);
                this.append(sb, "The filename of the plain text changelog, if generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportTitle", 2);
                this.append(sb, "The title of the reports. Defaults to: ${project.name} v${project.version} changelog", 3);
                this.append(sb, "", 0);
                this.append(sb, "simpleHTMLChangeLogFilename (Default: changelog.html)", 2);
                this.append(sb, "The filename of the simple HTML changelog, if generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "If true, the changelog will be printed to the Maven build log during packaging.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "gitlog:help", 0);
            this.append(sb, "Display help information on maven-gitlog-plugin.\nCall\n\u00a0\u00a0mvn\u00a0gitlog:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "show".equals(this.goal)) {
            this.append(sb, "gitlog:show", 0);
            this.append(sb, "Displays the git log in the maven build log. Use the generate goal to generate reports.", 1);
            this.append(sb, "", 0);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

