/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog;

import com.github.danielflower.mavenplugins.gitlog.NoGitRepositoryException;
import com.github.danielflower.mavenplugins.gitlog.filters.CommitFilter;
import com.github.danielflower.mavenplugins.gitlog.renderers.ChangeLogRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

class Generator {
    private final List<ChangeLogRenderer> renderers;
    private RevWalk walk;
    private Map<String, List<RevTag>> commitIDToTagsMap;
    private final List<CommitFilter> commitFilters;
    private final Log log;

    public Generator(List<ChangeLogRenderer> renderers, List<CommitFilter> commitFilters, Log log) {
        this.renderers = renderers;
        this.commitFilters = commitFilters == null ? new ArrayList() : commitFilters;
        this.log = log;
    }

    public void openRepository() throws IOException, NoGitRepositoryException {
        Repository repository;
        this.log.debug((CharSequence)"About to open git repository.");
        try {
            repository = ((RepositoryBuilder)new RepositoryBuilder().findGitDir()).build();
        }
        catch (IllegalArgumentException iae) {
            throw new NoGitRepositoryException();
        }
        this.log.debug((CharSequence)("Opened " + repository + ". About to load the commits."));
        this.walk = Generator.createWalk(repository);
        this.log.debug((CharSequence)"Loaded commits. about to load the tags.");
        this.commitIDToTagsMap = this.createCommitIDToTagsMap(repository, this.walk);
        this.log.debug((CharSequence)("Loaded tag map: " + this.commitIDToTagsMap));
    }

    public void generate(String reportTitle) throws IOException {
        this.generate(reportTitle, new Date(0L));
    }

    public void generate(String reportTitle, Date includeCommitsAfter) throws IOException {
        for (ChangeLogRenderer renderer : this.renderers) {
            renderer.renderHeader(reportTitle);
        }
        long dateInSecondsSinceEpoch = includeCommitsAfter.getTime() / 1000L;
        for (RevCommit commit : this.walk) {
            int commitTimeInSecondsSinceEpoch = commit.getCommitTime();
            if (dateInSecondsSinceEpoch >= (long)commitTimeInSecondsSinceEpoch) continue;
            List<RevTag> revTags = this.commitIDToTagsMap.get(commit.name());
            for (ChangeLogRenderer renderer : this.renderers) {
                if (revTags == null) continue;
                for (RevTag revTag : revTags) {
                    renderer.renderTag(revTag);
                }
            }
            if (!this.show(commit)) continue;
            for (ChangeLogRenderer renderer : this.renderers) {
                renderer.renderCommit(commit);
            }
        }
        this.walk.dispose();
        for (ChangeLogRenderer renderer : this.renderers) {
            renderer.renderFooter();
            renderer.close();
        }
    }

    private boolean show(RevCommit commit) {
        for (CommitFilter commitFilter : this.commitFilters) {
            if (commitFilter.renderCommit(commit)) continue;
            this.log.debug((CharSequence)("Commit filtered out by " + commitFilter.getClass().getSimpleName()));
            return false;
        }
        return true;
    }

    private static RevWalk createWalk(Repository repository) throws IOException {
        RevWalk walk = new RevWalk(repository);
        ObjectId head = repository.resolve("HEAD");
        if (head != null) {
            RevCommit mostRecentCommit = walk.parseCommit((AnyObjectId)head);
            walk.markStart(mostRecentCommit);
        }
        return walk;
    }

    private Map<String, List<RevTag>> createCommitIDToTagsMap(Repository repository, RevWalk revWalk) throws IOException {
        Map allTags = repository.getTags();
        HashMap<String, List<RevTag>> revTags = new HashMap<String, List<RevTag>>();
        for (Ref ref : allTags.values()) {
            try {
                RevTag revTag = revWalk.parseTag((AnyObjectId)ref.getObjectId());
                String commitID = revTag.getObject().getId().getName();
                if (!revTags.containsKey(commitID)) {
                    revTags.put(commitID, new ArrayList());
                }
                ((List)revTags.get(commitID)).add(revTag);
            }
            catch (IncorrectObjectTypeException e) {
                this.log.debug((CharSequence)("Light-weight tags not supported. Skipping " + ref.getName()));
            }
        }
        return revTags;
    }
}

