/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielfelgar.drawreceiptlib;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.github.danielfelgar.drawreceiptlib.IDrawItem;

public class DrawText
implements IDrawItem {
    private Paint paint = new Paint();
    private String text;
    private boolean newLine;

    public DrawText(String text) {
        this.text = text;
    }

    @Override
    public void drawOnCanvas(Canvas canvas, float x, float y) {
        canvas.drawText(this.text, this.getX(canvas, x), this.getY(y), this.paint);
    }

    private float getY(float y) {
        float baseline = -this.paint.ascent();
        return baseline + y;
    }

    private float getX(Canvas canvas, float x) {
        float xPos = x;
        if (this.paint.getTextAlign().equals((Object)Paint.Align.CENTER)) {
            xPos = canvas.getWidth() / 2;
        } else if (this.paint.getTextAlign().equals((Object)Paint.Align.RIGHT)) {
            xPos = canvas.getWidth();
        }
        return xPos;
    }

    @Override
    public int getHeight() {
        return this.newLine ? (int)this.getTextSize() : 0;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getColor() {
        return this.paint.getColor();
    }

    public void setColor(int color) {
        this.paint.setColor(color);
    }

    public float getTextSize() {
        return this.paint.getTextSize();
    }

    public void setTextSize(float textSize) {
        this.paint.setTextSize(textSize);
    }

    public void getTypeface() {
        this.paint.getTypeface();
    }

    public void setTypeface(Typeface typeface) {
        this.paint.setTypeface(typeface);
    }

    public void setAlign(Paint.Align align) {
        this.paint.setTextAlign(align);
    }

    public Paint.Align getAlign() {
        return this.paint.getTextAlign();
    }

    public void setNewLine(boolean newLine) {
        this.newLine = newLine;
    }

    public boolean getNewLine() {
        return this.newLine;
    }
}

