/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielfelgar.drawreceiptlib;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.danielfelgar.drawreceiptlib.IDrawItem;

public class DrawLine
implements IDrawItem {
    private Paint paint = new Paint();
    private int size;

    public DrawLine(int size) {
        this.size = size;
    }

    @Override
    public void drawOnCanvas(Canvas canvas, float x, float y) {
        float xPos = this.getX(canvas, x);
        canvas.drawLine(xPos, y + 5.0f, xPos + (float)this.size, y + 5.0f, this.paint);
    }

    private float getX(Canvas canvas, float x) {
        float xPos = x;
        if (this.paint.getTextAlign().equals((Object)Paint.Align.CENTER)) {
            xPos += (float)((canvas.getWidth() - this.size) / 2);
        } else if (this.paint.getTextAlign().equals((Object)Paint.Align.RIGHT)) {
            xPos += (float)(canvas.getWidth() - this.size);
        }
        return xPos;
    }

    @Override
    public int getHeight() {
        return 6;
    }

    public int getColor() {
        return this.paint.getColor();
    }

    public void setColor(int color) {
        this.paint.setColor(color);
    }

    public void setAlign(Paint.Align align) {
        this.paint.setTextAlign(align);
    }

    public Paint.Align getAlign() {
        return this.paint.getTextAlign();
    }
}

