/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielfelgar.drawreceiptlib;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.danielfelgar.drawreceiptlib.IDrawItem;

public class DrawImage
implements IDrawItem {
    private Paint paint = new Paint();
    private Bitmap bitmap;

    public DrawImage(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public void setAlign(Paint.Align align) {
        this.paint.setTextAlign(align);
    }

    public Paint.Align getAlign() {
        return this.paint.getTextAlign();
    }

    @Override
    public void drawOnCanvas(Canvas canvas, float x, float y) {
        canvas.drawBitmap(this.bitmap, this.getX(canvas, x), this.getY(y), this.paint);
    }

    private float getY(float y) {
        float baseline = -this.paint.ascent();
        return baseline + y;
    }

    private float getX(Canvas canvas, float x) {
        float xPos = x;
        if (this.paint.getTextAlign().equals((Object)Paint.Align.CENTER)) {
            xPos += (float)((canvas.getWidth() - this.bitmap.getWidth()) / 2);
        } else if (this.paint.getTextAlign().equals((Object)Paint.Align.RIGHT)) {
            xPos += (float)(canvas.getWidth() - this.bitmap.getWidth());
        }
        return xPos;
    }

    @Override
    public int getHeight() {
        return this.bitmap.getHeight();
    }
}

