/*
 * Decompiled with CFR 0.152.
 */
package com.dant.centersnapreyclerview;

import android.content.Context;
import android.graphics.PointF;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;

public class CenterLayoutManager
extends LinearLayoutManager {
    private SmoothScroller smoothScroller;
    private int anchor;

    public CenterLayoutManager(Context context) {
        super(context);
        this.smoothScroller = new SmoothScroller(context);
    }

    public void setAnchor(int anchor) {
        this.anchor = anchor;
    }

    public void setScrollSpeed(float scrollSpeed) {
        this.smoothScroller.setScrollSpeed(scrollSpeed);
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        this.smoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)this.smoothScroller);
    }

    private class SmoothScroller
    extends LinearSmoothScroller {
        private static final float MILLISECONDS_PER_INCH = 100.0f;
        private float milliSecondsPerInch;

        public SmoothScroller(Context context) {
            super(context);
            this.milliSecondsPerInch = -1.0f;
        }

        public void setScrollSpeed(float scrollSpeed) {
            this.milliSecondsPerInch = scrollSpeed;
        }

        public PointF computeScrollVectorForPosition(int targetPosition) {
            return CenterLayoutManager.this.computeScrollVectorForPosition(targetPosition);
        }

        public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
            switch (CenterLayoutManager.this.anchor) {
                case 1: {
                    return super.calculateDtToFit(viewStart, viewEnd, boxStart, boxEnd, -1);
                }
                case 2: {
                    return super.calculateDtToFit(viewStart, viewEnd, boxStart, boxEnd, 1);
                }
            }
            return (boxStart + boxEnd) / 2 - (viewStart + viewEnd) / 2;
        }

        protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
            return (this.milliSecondsPerInch > 0.0f ? this.milliSecondsPerInch : 100.0f) / (float)displayMetrics.densityDpi;
        }
    }
}

