/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.generators;

import com.github.dakusui.jcunit.constraint.ConstraintManager;
import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.JCUnitConfigurablePluginBase;
import com.github.dakusui.jcunit.core.factor.Factor;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.generators.TupleGenerator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class TupleGeneratorBase
extends JCUnitConfigurablePluginBase
implements TupleGenerator {
    protected Object[] params;
    private Factors factors = null;
    private long size = -1L;
    private ConstraintManager constraintManager;
    private Class<?> targetClass;

    @Override
    public final void init(Object[] processedParameters) {
        this.params = processedParameters;
        this.size = this.initializeTuples(this.params);
    }

    protected abstract long initializeTuples(Object[] var1);

    @Override
    public Iterator<Tuple> iterator() {
        return new Iterator<Tuple>(){
            private long cur = 0L;

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (TupleGeneratorBase.this.size < 0L || this.cur < 0L) {
                    throw new IllegalStateException();
                }
                return this.cur < TupleGeneratorBase.this.size;
            }

            @Override
            public Tuple next() {
                if (this.cur >= TupleGeneratorBase.this.size) {
                    throw new NoSuchElementException();
                }
                Tuple ret = TupleGeneratorBase.this.get(this.cur);
                ++this.cur;
                return ret;
            }
        };
    }

    @Override
    public final void setFactors(Factors factors) {
        this.factors = factors;
    }

    @Override
    public final Factors getFactors() {
        return this.factors;
    }

    @Override
    public final void setConstraintManager(ConstraintManager constraintManager) {
        this.constraintManager = constraintManager;
    }

    @Override
    public final ConstraintManager getConstraintManager() {
        return this.constraintManager;
    }

    @Override
    public Tuple get(long cur) {
        Tuple.Builder b = new Tuple.Builder();
        for (String f : this.factors.getFactorNames()) {
            b.put(f, this.factors.get((String)f).levels.get(this.getIndex(f, cur)));
        }
        return b.build();
    }

    private int getIndex(String factorName, long testId) {
        List<Object> levels = this.getFactor((String)factorName).levels;
        Tuple testCase = this.getTuple((int)testId);
        Object l = testCase.get(factorName);
        int ret = levels.indexOf(l);
        if (ret < 0) {
            for (int i = 0; i < levels.size(); ++i) {
                if (!this.arrayEquals(l, levels.get(i))) continue;
                ret = i;
                break;
            }
        }
        Checks.checkcond(ret >= 0, "%s cannot find '%s' in factor '%s'('%s')", this.getClass().getSimpleName(), l, factorName, levels);
        return ret;
    }

    private boolean arrayEquals(Object a, Object b) {
        if (a == null || b == null) {
            return b == a;
        }
        if (!a.getClass().isArray() || !b.getClass().isArray()) {
            return a.equals(b);
        }
        int lena = Array.getLength(a);
        if (lena != Array.getLength(b)) {
            return false;
        }
        for (int i = 0; i < lena; ++i) {
            this.arrayEquals(Array.get(a, i), Array.get(b, i));
        }
        return true;
    }

    @Override
    public long nextId(long tupleId) {
        return ++tupleId < this.size() ? tupleId : -1L;
    }

    @Override
    public long firstId() {
        return 0L;
    }

    @Override
    public void setTargetClass(Class<?> klazz) {
        this.targetClass = klazz;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public long size() {
        if (this.size < 0L) {
            throw new IllegalStateException();
        }
        return this.size;
    }

    public Factor getFactor(String factorName) {
        return this.factors.get(factorName);
    }

    public abstract Tuple getTuple(int var1);
}

