/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.fsm;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.fsm.FSMUtils;
import com.github.dakusui.jcunit.fsm.ScenarioSequence;
import com.github.dakusui.jcunit.fsm.spec.FSMSpec;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class Story<SUT, SPEC extends FSMSpec<SUT>>
implements Serializable,
FSMUtils.Synchronizable {
    private Class<SPEC> klazz;
    private final String name;
    private transient boolean performed;
    private final ScenarioSequence<SUT> setUp;
    private final ScenarioSequence<SUT> main;

    public Story(String name, ScenarioSequence<SUT> setUp, ScenarioSequence<SUT> main) {
        Checks.checknotnull(name);
        Checks.checknotnull(setUp);
        Checks.checknotnull(main);
        this.name = name;
        this.setUp = setUp;
        this.main = main;
        this.klazz = null;
    }

    public void reset() {
        this.performed = false;
    }

    public boolean isPerformed() {
        return this.performed;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object another) {
        if (another instanceof Story) {
            Story anotherStory = (Story)another;
            return this.name.equals(anotherStory.name) && this.setUp.equals(anotherStory.setUp) && this.main.equals(anotherStory.main);
        }
        return false;
    }

    static interface Performer<SUT> {
        public void perform(Story<SUT, ? extends FSMSpec<SUT>> var1, Object var2, SUT var3, FSMUtils.Synchronizer var4, ScenarioSequence.Observer var5);

        public static class Default<SUT>
        implements Performer<SUT> {
            public static final Performer INSTANCE = new Default();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(Story<SUT, ? extends FSMSpec<SUT>> story, Object context, SUT sut, FSMUtils.Synchronizer synchronizer, ScenarioSequence.Observer observer) {
                ((Story)story).performed = true;
                try {
                    ((Story)story).setUp.perform(context, ScenarioSequence.Type.setUp, sut, FSMUtils.Synchronizer.DUMMY, story, observer);
                }
                finally {
                    synchronizer.finishAndSynchronize(story);
                }
                ((Story)story).main.perform(context, ScenarioSequence.Type.main, sut, synchronizer, story, observer);
            }
        }
    }

    public static class Request<SUT> {
        public final String fsmName;
        public final SUT sut;
        public final ScenarioSequence.Observer.Factory observerFactory;

        public Request(String fsmName, SUT sut, ScenarioSequence.Observer.Factory observerFactory) {
            this.fsmName = Checks.checknotnull(fsmName);
            this.sut = Checks.checknotnull(sut);
            this.observerFactory = Checks.checknotnull(observerFactory);
        }

        public void execute(Performer<SUT> performer, FSMUtils.Synchronizer synchronizer, Object context) {
            ScenarioSequence.Observer.Factory observerFactory = this.observerFactory;
            Field storyField = FSMUtils.lookupStoryField(context, this.fsmName);
            Checks.checktest(storyField != null, "The field '%s' was not found or not public in the context '%s'", this.fsmName, context);
            try {
                Story story = (Story)storyField.get(context);
                Checks.checktest(story != null, "story parameter must not be null.", new Object[0]);
                performer.perform(story, context, this.sut, synchronizer, observerFactory.createObserver(this.fsmName));
            }
            catch (IllegalAccessException e) {
                Checks.rethrow(e);
            }
        }

        public <T> Callable createCallable(final Performer<SUT> performer, final FSMUtils.Synchronizer synchronizer, final T context) {
            return new Callable(){

                public Boolean call() {
                    Request.this.execute(performer, synchronizer, context);
                    return true;
                }
            };
        }

        public static class ArrayBuilder {
            private final List<Request<?>> requests = new LinkedList();

            public <SUT> ArrayBuilder add(String fsmName, SUT sut) {
                this.requests.add(new Request<SUT>(fsmName, sut, ScenarioSequence.Observer.Factory.ForSimple.INSTANCE));
                return this;
            }

            public Request<?>[] build() {
                return this.requests.toArray(new Request[this.requests.size()]);
            }
        }
    }
}

