/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.fsm;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.fsm.Action;
import com.github.dakusui.jcunit.fsm.Args;
import com.github.dakusui.jcunit.fsm.FSM;
import com.github.dakusui.jcunit.fsm.Scenario;
import com.github.dakusui.jcunit.fsm.ScenarioSequence;
import com.github.dakusui.jcunit.fsm.State;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StateRouter<SUT> {
    private final FSM<SUT> fsm;
    private final List<State<SUT>> destinations;
    private final Map<State<SUT>, ScenarioSequence<SUT>> routes;
    private final EdgeLister lister;

    public StateRouter(FSM<SUT> fsm, EdgeLister lister) {
        Checks.checknotnull(fsm);
        Checks.checknotnull(lister);
        this.destinations = Collections.unmodifiableList(Utils.singleton(fsm.states()));
        this.routes = new LinkedHashMap<State<SUT>, ScenarioSequence<SUT>>();
        this.lister = lister;
        for (State<SUT> each : this.destinations) {
            if (each.equals(fsm.initialState())) {
                this.routes.put(each, ScenarioSequence.EMPTY);
                continue;
            }
            this.routes.put(each, null);
        }
        this.fsm = fsm;
        this.traverse(fsm.initialState(), new LinkedList<Edge<SUT>>(), new LinkedHashSet<State<SUT>>());
        ArrayList<State<SUT>> unreachableDestinations = new ArrayList<State<SUT>>(this.destinations.size());
        for (State<SUT> each : this.destinations) {
            if (this.routes.get(each) != null) continue;
            unreachableDestinations.add(each);
        }
        Checks.checktest(unreachableDestinations.size() == 0, "The states '%s' can't be reached from the initial state of the given FSM.", unreachableDestinations, this.fsm.initialState());
    }

    public ScenarioSequence<SUT> routeTo(State<SUT> state) {
        Checks.checkcond(this.destinations.contains(state));
        return this.routes.get(state);
    }

    private void traverse(State<SUT> state, List<Edge<SUT>> path, Set<State<SUT>> visited) {
        for (Edge each : this.lister.possibleEdgesFrom(state)) {
            State<SUT> next = this.next(state, each);
            if (next == State.VOID) {
                return;
            }
            if (visited.contains(next)) continue;
            visited.add(next);
            LinkedList<Edge<SUT>> pathToNext = new LinkedList<Edge<SUT>>(path);
            pathToNext.add(each);
            if (this.destinations.contains(next)) {
                this.routes.put(next, this.buildStoryFromTransitions(pathToNext));
            }
            this.traverse(next, pathToNext, visited);
        }
    }

    private ScenarioSequence<SUT> buildStoryFromTransitions(final List<Edge<SUT>> pathToNext) {
        return new ScenarioSequence.Base<SUT>(){

            @Override
            public int size() {
                return pathToNext.size();
            }

            @Override
            public State<SUT> state(int i) {
                Checks.checkcond(i >= 0 && i < this.size());
                State ret = StateRouter.this.fsm.initialState();
                for (int c = 0; c < i; ++c) {
                    StateRouter.this.next(ret, new Edge(this.action(i), this.args(i)));
                }
                return ret;
            }

            @Override
            public Action<SUT> action(int i) {
                return ((Edge)pathToNext.get((int)i)).action;
            }

            @Override
            public Object arg(int i, int j) {
                return this.args(i).values()[j];
            }

            @Override
            public boolean hasArg(int i, int j) {
                Checks.checkcond(j >= 0);
                return this.args(i).size() > j;
            }

            @Override
            public Args args(int i) {
                return ((Edge)pathToNext.get((int)i)).args;
            }

            @Override
            public String toString() {
                return ScenarioSequence.Utils.toString(this);
            }
        };
    }

    private State<SUT> next(State<SUT> state, Edge<SUT> t) {
        return state.expectation(t.action, (Args)t.args).state;
    }

    static class EdgeLister {
        private final List<ScenarioSequence> mainScenarioSequences;

        EdgeLister(List<ScenarioSequence> scenarioSequences) {
            this.mainScenarioSequences = Checks.checknotnull(scenarioSequences);
        }

        protected List<Edge> possibleEdgesFrom(State state) {
            LinkedList<Edge> ret = new LinkedList<Edge>();
            for (ScenarioSequence eachScenario : this.mainScenarioSequences) {
                for (int i = 0; i < eachScenario.size(); ++i) {
                    Edge t;
                    Scenario each = eachScenario.get(i);
                    if (!each.given.equals(state) || each.then().state.equals(State.VOID) || ret.contains(t = new Edge(eachScenario.action(i), eachScenario.args(i)))) continue;
                    ret.add(t);
                }
            }
            return ret;
        }
    }

    public static class Edge<SUT> {
        public final Action<SUT> action;
        public final Args args;

        public Edge(Action<SUT> action, Args args) {
            this.action = action;
            this.args = args;
        }

        public int hashCode() {
            return this.action.hashCode();
        }

        public boolean equals(Object anotherObject) {
            if (!(anotherObject instanceof Edge)) {
                return false;
            }
            Edge another = (Edge)anotherObject;
            return this.action.equals(another.action) && Arrays.deepEquals(this.args.values(), another.args.values());
        }
    }
}

