/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.fsm;

import com.github.dakusui.jcunit.constraint.ConstraintManager;
import com.github.dakusui.jcunit.constraint.constraintmanagers.ConstraintManagerBase;
import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.exceptions.UndefinedSymbol;
import com.github.dakusui.jcunit.fsm.Action;
import com.github.dakusui.jcunit.fsm.Args;
import com.github.dakusui.jcunit.fsm.Expectation;
import com.github.dakusui.jcunit.fsm.FSMFactors;
import com.github.dakusui.jcunit.fsm.Parameters;
import com.github.dakusui.jcunit.fsm.ScenarioSequence;
import com.github.dakusui.jcunit.fsm.State;
import java.util.Collections;
import java.util.List;

public class FSMConstraintManager<SUT>
extends ConstraintManagerBase {
    private final ConstraintManager baseConstraintManager;
    private final List<Parameters.LocalConstraintManager> localCMs;

    FSMConstraintManager(ConstraintManager baseCM, List<Parameters.LocalConstraintManager> localCMS) {
        Checks.checknotnull(baseCM);
        this.baseConstraintManager = baseCM;
        this.localCMs = Collections.unmodifiableList(Checks.checknotnull(localCMS));
    }

    @Override
    public boolean check(Tuple tuple) throws UndefinedSymbol {
        if (!this.baseConstraintManager.check(tuple)) {
            return false;
        }
        FSMFactors fsmFactors = (FSMFactors)this.getFactors();
        for (String string : fsmFactors.getFSMNames()) {
            ScenarioSequence seq = new ScenarioSequence.BuilderFromTuple().setFSMFactors(fsmFactors).setTuple(tuple).setFSMName(string).build();
            State expectedState = null;
            for (int i = 0; i < fsmFactors.historyLength(string); ++i) {
                State state = seq.state(i);
                if (state == null) {
                    throw new UndefinedSymbol(new String[]{fsmFactors.stateFactorName(string, i)});
                }
                if (expectedState != null && expectedState != state) {
                    return false;
                }
                Action action = seq.action(i);
                if (action == null) {
                    throw new UndefinedSymbol(new String[]{fsmFactors.actionFactorName(string, i)});
                }
                if (state == State.VOID && action != Action.VOID) {
                    return false;
                }
                int numParams = action.numParameterFactors();
                for (int j = 0; j < numParams; ++j) {
                    if (!seq.hasArg(i, j)) {
                        throw new UndefinedSymbol(new String[]{fsmFactors.paramFactorName(string, i, j)});
                    }
                    if (j >= numParams && seq.arg(i, j) != FSMFactors.VOID) {
                        return false;
                    }
                    if (this.isPossible(action.parameterFactorLevels(j), seq.arg(i, j))) continue;
                    return false;
                }
                Args args = seq.args(i);
                Expectation expectation = state.expectation(action, args);
                if (expectation == null) {
                    return false;
                }
                expectedState = expectation.state;
            }
        }
        for (Parameters.LocalConstraintManager localConstraintManager : this.localCMs) {
            if (localConstraintManager.check(tuple)) continue;
            return false;
        }
        return true;
    }

    private boolean isPossible(Object[] possibleValues, Object value) {
        for (Object pv : possibleValues) {
            if (!Utils.eq(pv, value)) continue;
            return true;
        }
        return false;
    }
}

