/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.exceptions;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.exceptions.JCUnitException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public class NestableException
extends JCUnitException {
    private final List<Throwable> nested = new LinkedList<Throwable>();

    public NestableException(String message, Throwable t) {
        super(message, t);
    }

    public NestableException(String message) {
        super(message, null);
    }

    public void addChild(Throwable child) {
        this.nested.add(Checks.checknotnull(child));
    }

    @Override
    public String getMessage() {
        String ret = super.getMessage();
        if (!this.nested.isEmpty()) {
            ret = ret + ":[";
            boolean isFirst = true;
            for (Throwable each : this.nested) {
                if (!isFirst) {
                    ret = ret + ",";
                }
                ret = ret + each.getMessage();
                isFirst = false;
            }
            ret = ret + "]";
        }
        return ret;
    }

    public boolean hasChildren() {
        return !this.nested.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            ps.println();
            for (Throwable each : this.nested) {
                each.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            pw.println();
            for (Throwable each : this.nested) {
                each.printStackTrace(pw);
            }
        }
    }
}

