/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.enumerator.tuple;

import com.github.dakusui.enumerator.Enumerator;
import com.github.dakusui.enumerator.tuple.AttrValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CartesianEnumerator<T, U>
extends Enumerator<AttrValue<T, U>> {
    private final ArrayList<T> attrsInReverseOrder;
    private Map<T, List<AttrValue<T, U>>> attrValues = new HashMap<T, List<AttrValue<T, U>>>();

    public CartesianEnumerator(List<AttrValue<T, U>> attributeValues) {
        super(attributeValues, CartesianEnumerator.countAttributes(attributeValues.toArray(new AttrValue[0])));
        this.attrsInReverseOrder = new ArrayList(this.k);
        for (AttrValue cur : this.items) {
            if (this.attrsInReverseOrder.contains(cur.attr())) continue;
            this.attrsInReverseOrder.add(cur.attr());
        }
        this.attrValues = this.attrValues();
        Collections.reverse(this.attrsInReverseOrder);
    }

    private static int countAttributes(AttrValue<Object, Object>[] attributeValues) {
        HashSet<AttrValue<Object, Object>> attrs = new HashSet<AttrValue<Object, Object>>();
        for (AttrValue<Object, Object> attrValue : attributeValues) {
            attrs.add(attrValue);
        }
        return attrs.size();
    }

    @Override
    protected List<AttrValue<T, U>> get_Protected(long index) {
        LinkedList<AttrValue<T, U>> ret = new LinkedList<AttrValue<T, U>>();
        for (T key : this.attrsInReverseOrder) {
            List<AttrValue<T, U>> values = this.attrValues.get(key);
            int sz = values.size();
            int mod = (int)(index % (long)sz);
            index /= (long)sz;
            ret.add(values.get(mod));
        }
        Collections.reverse(ret);
        return ret;
    }

    @Override
    public long size() {
        long ret = 1L;
        for (List<AttrValue<T, U>> values : this.attrValues().values()) {
            long sz = values.size();
            if (sz > Long.MAX_VALUE / ret) {
                throw new IllegalArgumentException(String.format("Overflow. Too many attributes or attribute values: %d * %d", ret, sz));
            }
            ret *= sz;
        }
        return ret;
    }

    private Map<T, List<AttrValue<T, U>>> attrValues() {
        HashMap ret = new HashMap();
        for (AttrValue cur : this.items) {
            LinkedList<AttrValue> values = (LinkedList<AttrValue>)ret.get(cur.attr());
            if (values == null) {
                values = new LinkedList<AttrValue>();
                ret.put(cur.attr(), values);
            }
            values.add(cur);
        }
        return ret;
    }
}

