/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.dadiyang.httpinvoker.requestor.HttpRequest;
import com.github.dadiyang.httpinvoker.requestor.MultiPart;
import com.github.dadiyang.httpinvoker.util.ObjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ParamUtils {
    private static final char UPPER_A = 'A';
    private static final char UPPER_Z = 'Z';
    private static final char LOWER_A = 'a';
    private static final char LOWER_Z = 'z';
    private static final String FILE_NAME = "fileName";
    private static final String DEFAULT_UPLOAD_FORM_KEY = "media";
    private static final String FORM_KEY = "formKey";
    private static final List<Class<?>> BASIC_TYPE = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class, String.class, Void.class);

    private ParamUtils() {
        throw new UnsupportedOperationException("utils should not be initialized!");
    }

    public static boolean isBasicType(Class<?> clz) {
        if (clz == null) {
            return false;
        }
        return clz.isPrimitive() || BASIC_TYPE.contains(clz);
    }

    public static boolean isCollection(Object arg) {
        if (arg == null) {
            return false;
        }
        return arg.getClass().isArray() || arg instanceof Collection;
    }

    public static Map<String, String> toMapStringString(Object value, String prefix) {
        if (value == null) {
            return Collections.emptyMap();
        }
        if (ParamUtils.isBasicType(value.getClass())) {
            return Collections.singletonMap(prefix, String.valueOf(value));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                String key = prefix + "[" + i++ + "]";
                Object item = Array.get(value, 0);
                if (ParamUtils.isBasicType(item.getClass())) {
                    map.put(prefix + "[" + i + "]", String.valueOf(item));
                    continue;
                }
                map.putAll(ParamUtils.toMapStringString(item, key));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Iterator it = collection.iterator();
            int i = 0;
            while (it.hasNext()) {
                String key = prefix + "[" + i++ + "]";
                Object item = it.next();
                if (ParamUtils.isBasicType(item.getClass())) {
                    map.put(prefix + "[" + i++ + "]", String.valueOf(item));
                    continue;
                }
                map.putAll(ParamUtils.toMapStringString(item, key));
            }
        } else {
            JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)value));
            for (Map.Entry entry : obj.entrySet()) {
                String key = prefix == null || prefix.isEmpty() ? (String)entry.getKey() : prefix + "[" + (String)entry.getKey() + "]";
                if (ParamUtils.isBasicType(value.getClass())) {
                    map.put(key, String.valueOf(value));
                    continue;
                }
                map.putAll(ParamUtils.toMapStringString(entry.getValue(), key));
            }
        }
        return map;
    }

    public static String toQueryString(Object arg) {
        if (arg == null) {
            return "";
        }
        StringBuilder qs = new StringBuilder("?");
        JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)arg));
        for (Map.Entry entry : obj.entrySet()) {
            if (ParamUtils.isCollection(entry.getValue())) {
                qs.append(ParamUtils.collectionToQueryString(obj, entry));
                continue;
            }
            String value = entry.getValue() == null ? "" : entry.getValue().toString();
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            qs.append((String)entry.getKey()).append("=").append(value).append("&");
        }
        return qs.substring(0, qs.length() - 1);
    }

    private static String collectionToQueryString(JSONObject obj, Map.Entry<String, Object> entry) {
        JSONArray arr = obj.getJSONArray(entry.getKey());
        StringBuilder valBuilder = new StringBuilder();
        for (Object item : arr) {
            valBuilder.append(entry.getKey()).append("=").append(item).append("&");
        }
        return valBuilder.toString();
    }

    public static char changeCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c + 32);
            return c;
        }
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
            return c;
        }
        return c;
    }

    public static String changeInitialCase(String c) {
        if (c == null || c.isEmpty()) {
            return c;
        }
        return ParamUtils.changeCase(c.charAt(0)) + c.substring(1);
    }

    public static MultiPart convertInputStreamAndFile(HttpRequest request) throws IOException {
        InputStream in;
        Map<String, Object> paramMap = request.getData();
        String formKey = DEFAULT_UPLOAD_FORM_KEY;
        if (request.getFileFormKey() != null && !request.getFileFormKey().isEmpty()) {
            formKey = request.getFileFormKey();
        } else if (paramMap != null && paramMap.containsKey(FORM_KEY)) {
            formKey = paramMap.get(FORM_KEY).toString();
        }
        ArrayList<MultiPart.Part> parts = new ArrayList<MultiPart.Part>();
        String fileName = FILE_NAME;
        if (paramMap != null) {
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                if (ObjectUtils.equals(entry.getKey(), FILE_NAME)) {
                    fileName = String.valueOf(entry.getValue());
                }
                parts.add(new MultiPart.Part(entry.getKey(), String.valueOf(entry.getValue())));
            }
        }
        if (File.class.isAssignableFrom(request.getBody().getClass())) {
            File file = (File)request.getBody();
            in = new FileInputStream(file);
            fileName = file.getName();
        } else {
            in = (InputStream)request.getBody();
        }
        parts.add(new MultiPart.Part(formKey, fileName, in));
        return new MultiPart(parts);
    }

    public static boolean isUploadRequest(Object bodyParam) {
        return bodyParam != null && (bodyParam instanceof MultiPart || InputStream.class.isAssignableFrom(bodyParam.getClass()) || File.class.isAssignableFrom(bodyParam.getClass()));
    }
}

