/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.requestor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.github.dadiyang.httpinvoker.annotation.ExpectedCode;
import com.github.dadiyang.httpinvoker.annotation.HttpReq;
import com.github.dadiyang.httpinvoker.requestor.HttpResponse;
import com.github.dadiyang.httpinvoker.requestor.ResponseProcessor;
import com.github.dadiyang.httpinvoker.util.ObjectUtils;
import com.github.dadiyang.httpinvoker.util.ParamUtils;
import java.io.BufferedInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResultBeanResponseProcessor
implements ResponseProcessor {
    private static final Logger log = LoggerFactory.getLogger(ResultBeanResponseProcessor.class);
    private static final String CODE = "code";
    private static final String DATA = "data";
    private static final String MESSAGE = "message";
    private static final String MSG = "msg";
    private Map<Class<?>, Boolean> isResultBeanCache = new ConcurrentHashMap();

    @Override
    public Object process(HttpResponse response, Method method) {
        String rs = response.getBody();
        if (rs == null || rs.trim().isEmpty()) {
            return null;
        }
        Class<BufferedInputStream> returnType = method.getReturnType();
        if (returnType == byte[].class) {
            return response.getBodyAsBytes();
        }
        if (returnType != Object.class && returnType.isAssignableFrom(BufferedInputStream.class)) {
            return response.getBodyStream();
        }
        if (returnType != Object.class && returnType.isAssignableFrom(response.getClass())) {
            return response;
        }
        ExpectedCode expectedCode = this.getExpectedAnnotation(method);
        if (ObjectUtils.equals(this.isResultBean(expectedCode, returnType), true)) {
            return this.parseObject(method, rs);
        }
        JSONObject obj = JSON.parseObject((String)rs);
        if (this.isResponseNotResultBean(expectedCode, obj)) {
            return this.parseObject(method, rs);
        }
        if (this.isExpectedCode(expectedCode, obj)) {
            return this.parseObject(method, obj.getString(DATA));
        }
        HttpReq req = method.getAnnotation(HttpReq.class);
        String uri = req != null ? req.value() : method.getName();
        String errMsg = obj.containsKey((Object)MESSAGE) ? obj.getString(MESSAGE) : obj.getString(MSG);
        String msg = "\u8bf7\u6c42api\u5931\u8d25, uri: " + uri + ", \u9519\u8bef\u4fe1\u606f: " + errMsg;
        log.warn(msg);
        throw new IllegalStateException(msg);
    }

    private boolean isExpectedCode(ExpectedCode expectedCode, JSONObject obj) {
        if (expectedCode != null) {
            return this.isExpectedCode(obj, expectedCode.value(), expectedCode.codeFieldName(), expectedCode.ignoreFieldInitialCase());
        }
        return this.isExpectedCode(obj, 0, CODE, true);
    }

    private boolean isExpectedCode(JSONObject obj, int expectedCode, String codeField, boolean ignoreFieldInitialCase) {
        if (!obj.containsKey((Object)codeField) && ignoreFieldInitialCase) {
            codeField = ParamUtils.changeInitialCase(codeField);
        }
        return ObjectUtils.equals(expectedCode, obj.getInteger(codeField));
    }

    private ExpectedCode getExpectedAnnotation(Method method) {
        if (method.isAnnotationPresent(ExpectedCode.class)) {
            return method.getAnnotation(ExpectedCode.class);
        }
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.isAnnotationPresent(ExpectedCode.class)) {
            return clazz.getAnnotation(ExpectedCode.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean isResultBean(ExpectedCode expectedCode, Class<?> returnType) {
        if (this.isResultBeanCache.containsKey(returnType)) {
            return this.isResultBeanCache.get(returnType);
        }
        ResultBeanResponseProcessor resultBeanResponseProcessor = this;
        synchronized (resultBeanResponseProcessor) {
            if (this.isResultBeanCache.containsKey(returnType)) {
                return this.isResultBeanCache.get(returnType);
            }
            if (ParamUtils.isBasicType(returnType) || returnType.isInterface()) {
                return false;
            }
            Field[] fields = this.getDeclaredFields(returnType);
            boolean hasCode = false;
            boolean hasMsg = false;
            boolean hasData = false;
            String codeField = expectedCode == null ? CODE : expectedCode.codeFieldName();
            boolean ignoreInitialCase = expectedCode == null || expectedCode.ignoreFieldInitialCase();
            for (Field field : fields) {
                String fieldName = field.getName().toLowerCase();
                hasCode = hasCode || ObjectUtils.equals(codeField, fieldName) || ignoreInitialCase && ObjectUtils.equals(fieldName, ParamUtils.changeInitialCase(codeField));
                hasMsg = hasMsg || ObjectUtils.equals(MSG, fieldName) || ObjectUtils.equals(MESSAGE, fieldName);
                hasData = hasData || ObjectUtils.equals(DATA, fieldName);
            }
            boolean isResultBean = hasCode && hasMsg && hasData;
            this.isResultBeanCache.put(returnType, isResultBean);
            return isResultBean;
        }
    }

    private Field[] getDeclaredFields(Class<?> returnType) {
        if (returnType.getSuperclass() == Object.class) {
            return returnType.getDeclaredFields();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> type = returnType;
        while (type != Object.class && !type.isInterface()) {
            fields.addAll(Arrays.asList(type.getDeclaredFields()));
            type = returnType.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    private boolean isResponseNotResultBean(ExpectedCode expectedCode, JSONObject obj) {
        boolean hasCode = false;
        boolean hasMsg = false;
        boolean hasData = false;
        String codeField = expectedCode == null ? CODE : expectedCode.codeFieldName();
        boolean ignoreInitialCase = expectedCode == null || expectedCode.ignoreFieldInitialCase();
        for (String key : obj.keySet()) {
            String fieldName = key == null ? "" : key.toLowerCase();
            hasCode = hasCode || ObjectUtils.equals(codeField, fieldName) || ignoreInitialCase && ObjectUtils.equals(fieldName, ParamUtils.changeInitialCase(codeField));
            hasMsg = hasMsg || ObjectUtils.equals(MSG, fieldName) || ObjectUtils.equals(MESSAGE, fieldName);
            hasData = hasData || ObjectUtils.equals(DATA, fieldName);
        }
        return !hasCode || !hasMsg && !hasData;
    }

    private Object parseObject(Method method, String dataString) {
        if (dataString == null || dataString.trim().isEmpty()) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.class || returnType == Void.TYPE) {
            return null;
        }
        if (returnType == Object.class || returnType == String.class || method.getReturnType() == CharSequence.class) {
            return dataString;
        }
        return JSON.parseObject((String)dataString, (Type)method.getGenericReturnType(), (Feature[])new Feature[0]);
    }
}

