/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.propertyresolver;

import com.github.dadiyang.httpinvoker.propertyresolver.PropertyResolver;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class MultiSourcePropertyResolver
implements PropertyResolver {
    private Set<PropertyResolver> resolvers;

    public MultiSourcePropertyResolver(Set<PropertyResolver> resolvers) {
        if (resolvers == null) {
            throw new IllegalArgumentException("resolvers must not be null");
        }
        this.resolvers = new LinkedHashSet<PropertyResolver>(resolvers);
    }

    public MultiSourcePropertyResolver() {
        this.resolvers = new LinkedHashSet<PropertyResolver>();
    }

    public Set<PropertyResolver> getResolvers() {
        return Collections.unmodifiableSet(this.resolvers);
    }

    public void addPropertyResolver(PropertyResolver resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public boolean containsProperty(String key) {
        for (PropertyResolver resolver : this.resolvers) {
            if (!resolver.containsProperty(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProperty(String key) {
        for (PropertyResolver resolver : this.resolvers) {
            if (!resolver.containsProperty(key)) continue;
            return resolver.getProperty(key);
        }
        return null;
    }
}

