/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.entity.foundation.variable;

import com.github.dactiv.common.type.FieldType;
import com.github.dactiv.common.utils.ConvertUtils;
import com.github.dactiv.showcase.entity.IdEntity;
import com.github.dactiv.showcase.entity.foundation.variable.DictionaryCategory;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(name="TB_DATA_DICTIONARY")
public class DataDictionary
extends IdEntity {
    private static final long serialVersionUID = 1L;
    private String name;
    private String value;
    private String type = "S";
    private String remark;
    public DictionaryCategory category;

    public DataDictionary() {
    }

    public DataDictionary(String name, String value, String type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    @NotEmpty
    @Length(max=256)
    @Column(length=256, nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotEmpty
    @Length(max=32)
    @Column(length=32, nullable=false)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @NotEmpty
    @Length(max=1)
    @Column(length=1, nullable=false)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Length(max=512)
    @Column(length=512)
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_CATEGORY_ID", nullable=false)
    public DictionaryCategory getCategory() {
        return this.category;
    }

    public void setCategory(DictionaryCategory category) {
        this.category = category;
    }

    @Transient
    public Object getReadValue() {
        return ConvertUtils.convertToObject((String)this.value, (Class)FieldType.valueOf((String)this.type).getValue());
    }
}

