/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web.foundation.variable;

import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.annotation.OperatingAudit;
import com.github.dactiv.showcase.common.enumeration.SystemDictionaryCode;
import com.github.dactiv.showcase.entity.foundation.variable.DataDictionary;
import com.github.dactiv.showcase.service.foundation.SystemVariableManager;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@OperatingAudit(value="\u6570\u636e\u5b57\u5178\u7ba1\u7406")
@RequestMapping(value={"/foundation/variable/data-dictionary"})
public class DataDictionaryController {
    @Autowired
    private SystemVariableManager systemDictionaryManager;

    @RequestMapping(value={"view"})
    public Page<DataDictionary> view(PageRequest pageRequest, HttpServletRequest request) {
        List filters = PropertyFilters.build((HttpServletRequest)request, (boolean)true);
        if (!pageRequest.isOrderBySetted()) {
            pageRequest.setOrderBy("id");
            pageRequest.setOrderDir("desc");
        }
        request.setAttribute("valueTypes", (Object)SystemVariableUtils.getVariables((SystemDictionaryCode)SystemDictionaryCode.ValueType, (String[])new String[0]));
        request.setAttribute("categoriesList", (Object)this.systemDictionaryManager.getDictionaryCategories());
        return this.systemDictionaryManager.searchDataDictionaryPage(pageRequest, filters);
    }

    @RequestMapping(value={"save"})
    @OperatingAudit(function="\u4fdd\u5b58\u6216\u66f4\u65b0\u6570\u636e\u5b57\u5178")
    public String save(@ModelAttribute(value="entity") DataDictionary entity, String categoryId, RedirectAttributes redirectAttributes) {
        if (StringUtils.isEmpty((CharSequence)categoryId)) {
            entity.setCategory(null);
        } else {
            entity.setCategory(this.systemDictionaryManager.getDictionaryCategory(categoryId));
        }
        this.systemDictionaryManager.saveDataDictionary(entity);
        redirectAttributes.addFlashAttribute("success", (Object)"\u4fdd\u5b58\u6210\u529f");
        return "redirect:/foundation/variable/data-dictionary/view";
    }

    @RequestMapping(value={"read"})
    public String read(Model model) {
        model.addAttribute("valueTypes", (Object)SystemVariableUtils.getVariables((SystemDictionaryCode)SystemDictionaryCode.ValueType, (String[])new String[0]));
        model.addAttribute("categoriesList", (Object)this.systemDictionaryManager.getDictionaryCategories());
        return "/foundation/variable/data-dictionary/read";
    }

    @RequestMapping(value={"delete"})
    @OperatingAudit(function="\u5220\u9664\u6570\u636e\u5b57\u5178")
    public String delete(@RequestParam(value="ids") List<String> ids, RedirectAttributes redirectAttributes) {
        this.systemDictionaryManager.deleteDataDictionary(ids);
        redirectAttributes.addFlashAttribute("success", (Object)("\u5220\u9664" + ids.size() + "\u6761\u4fe1\u606f\u6210\u529f"));
        return "redirect:/foundation/variable/data-dictionary/view";
    }

    @ModelAttribute(value="entity")
    public DataDictionary bindingModel(@RequestParam(value="id", required=false) String id) {
        DataDictionary dataDictionary = new DataDictionary();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            dataDictionary = this.systemDictionaryManager.getDataDictionary(id);
        }
        return dataDictionary;
    }
}

