/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web.account;

import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.annotation.OperatingAudit;
import com.github.dactiv.showcase.common.enumeration.entity.ResourceType;
import com.github.dactiv.showcase.entity.account.Resource;
import com.github.dactiv.showcase.service.account.AccountManager;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@OperatingAudit(value="\u8d44\u6e90\u7ba1\u7406")
@RequestMapping(value={"/account/resource"})
public class ResourceController {
    @Autowired
    private AccountManager accountManager;

    @RequestMapping(value={"view"})
    public Page<Resource> view(PageRequest pageRequest, HttpServletRequest request) {
        List filters = PropertyFilters.build((HttpServletRequest)request, (boolean)true);
        request.setAttribute("resourceType", (Object)SystemVariableUtils.getVariables(ResourceType.class, (Object[])new Object[0]));
        request.setAttribute("resourcesList", (Object)this.accountManager.getResources(new String[0]));
        if (!pageRequest.isOrderBySetted()) {
            pageRequest.setOrderBy("sort");
            pageRequest.setOrderDir("desc");
        }
        return this.accountManager.searchResourcePage(pageRequest, filters);
    }

    @RequestMapping(value={"save"})
    @OperatingAudit(function="\u4fdd\u5b58\u6216\u66f4\u65b0\u8d44\u6e90")
    public String save(@ModelAttribute(value="entity") Resource entity, String parentId, RedirectAttributes redirectAttributes) {
        if (StringUtils.isEmpty((CharSequence)parentId)) {
            entity.setParent(null);
        } else {
            Resource parent = this.accountManager.getResource(parentId);
            entity.setParent(parent);
        }
        this.accountManager.saveResource(entity);
        redirectAttributes.addFlashAttribute("success", (Object)"\u4fdd\u5b58\u6210\u529f");
        return "redirect:/account/resource/view";
    }

    @RequestMapping(value={"read"})
    public String read(@RequestParam(value="id", required=false) String id, Model model, @ModelAttribute(value="entity") Resource entity) {
        model.addAttribute("resourceType", (Object)SystemVariableUtils.getVariables(ResourceType.class, (Object[])new Object[0]));
        if (StringUtils.isEmpty((CharSequence)id)) {
            model.addAttribute("resourcesList", (Object)this.accountManager.getResources(new String[0]));
            entity.setSort(Long.valueOf(this.accountManager.getResourceCount() + 1L));
        } else {
            model.addAttribute("resourcesList", (Object)this.accountManager.getResources(new String[]{id}));
        }
        return "account/resource/read";
    }

    @RequestMapping(value={"delete"})
    @OperatingAudit(function="\u5220\u9664\u8d44\u6e90")
    public String delete(@RequestParam(value="ids") List<String> ids, RedirectAttributes redirectAttributes) {
        this.accountManager.deleteResources(ids);
        redirectAttributes.addFlashAttribute("success", (Object)("\u5220\u9664" + ids.size() + "\u6761\u4fe1\u606f\u6210\u529f"));
        return "redirect:/account/resource/view";
    }

    @ModelAttribute(value="entity")
    public Resource bindingModel(@RequestParam(value="id", required=false) String id) {
        Resource resource = new Resource();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            resource = this.accountManager.getResource(id);
        }
        return resource;
    }
}

