/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web.account;

import com.github.dactiv.common.utils.ServletUtils;
import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.SystemVariableUtils;
import com.github.dactiv.showcase.common.annotation.OperatingAudit;
import com.github.dactiv.showcase.common.enumeration.entity.GroupType;
import com.github.dactiv.showcase.common.enumeration.entity.State;
import com.github.dactiv.showcase.entity.account.Group;
import com.github.dactiv.showcase.service.account.AccountManager;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@OperatingAudit(value="\u7ec4\u7ba1\u7406")
@RequestMapping(value={"/account/group"})
public class GroupController {
    @Autowired
    private AccountManager accountManager;

    @RequestMapping(value={"view"})
    public Page<Group> view(PageRequest pageRequest, HttpServletRequest request) {
        List filters = PropertyFilters.build((HttpServletRequest)request, (boolean)true);
        request.setAttribute("states", (Object)SystemVariableUtils.getVariables(State.class, (Object[])new Object[]{3}));
        request.setAttribute("groupsList", (Object)this.accountManager.getGroup(GroupType.RoleGorup, new String[0]));
        if (!pageRequest.isOrderBySetted()) {
            pageRequest.setOrderBy("id");
            pageRequest.setOrderDir("desc");
        }
        filters.add(PropertyFilters.build((String)"EQS_type", (String)GroupType.RoleGorup.getValue()));
        return this.accountManager.searchGroupPage(pageRequest, filters);
    }

    @RequestMapping(value={"save"})
    @OperatingAudit(function="\u4fdd\u5b58\u6216\u66f4\u65b0\u7ec4")
    public String save(@ModelAttribute(value="entity") Group entity, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        String parentId = request.getParameter("parentId");
        if (StringUtils.isEmpty((CharSequence)parentId)) {
            entity.setParent(null);
        } else {
            entity.setParent(this.accountManager.getGroup(parentId));
        }
        List resourceIds = ServletUtils.getParameterValues((ServletRequest)request, (String)"resourceId");
        entity.setResourcesList(this.accountManager.getResources(resourceIds));
        this.accountManager.saveGroup(entity);
        redirectAttributes.addFlashAttribute("success", (Object)"\u4fdd\u5b58\u6210\u529f");
        return "redirect:/account/group/view";
    }

    @RequestMapping(value={"read"})
    public String read(@RequestParam(value="id", required=false) String id, Model model) {
        model.addAttribute("resourcesList", (Object)this.accountManager.getResources(new String[0]));
        model.addAttribute("states", (Object)SystemVariableUtils.getVariables(State.class, (Object[])new Object[]{3}));
        if (StringUtils.isEmpty((CharSequence)id)) {
            model.addAttribute("groupsList", (Object)this.accountManager.getGroup(GroupType.RoleGorup, new String[0]));
        } else {
            model.addAttribute("groupsList", (Object)this.accountManager.getGroup(GroupType.RoleGorup, new String[]{id}));
        }
        return "account/group/read";
    }

    @RequestMapping(value={"delete"})
    @OperatingAudit(function="\u5220\u9664\u7ec4")
    public String delete(@RequestParam(value="ids") List<String> ids, RedirectAttributes redirectAttributes) {
        this.accountManager.deleteGroups(ids);
        redirectAttributes.addFlashAttribute("success", (Object)("\u5220\u9664" + ids.size() + "\u6761\u4fe1\u606f\u6210\u529f"));
        return "redirect:/account/group/view";
    }

    @ModelAttribute(value="entity")
    public Group bindingModel(@RequestParam(value="id", required=false) String id) {
        Group group = new Group();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            group = this.accountManager.getGroup(id);
        }
        return group;
    }
}

